//===- TableGen'erated file -------------------------------------*- C++ -*-===//
//
// DAG Instruction Selector for the PPC target
//
// Automatically generated file, do not edit!
//
//===----------------------------------------------------------------------===//

// *** NOTE: This file is #included into the middle of the target
// *** instruction selector class.  These functions are really methods.


// Predicate functions.
inline bool Predicate_V_immneg0(SDNode *N) const {

  return PPC::isAllNegativeZeroVector(N);

}
inline bool Predicate_atomic_cmp_swap_16(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_atomic_cmp_swap_32(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_atomic_cmp_swap_64(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;

}
inline bool Predicate_atomic_cmp_swap_8(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_atomic_load_add_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_add_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_add_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_add_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_and_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_and_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_and_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_and_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_max_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_max_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_max_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_max_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_min_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_min_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_min_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_min_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_nand_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_nand_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_nand_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_nand_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_or_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_or_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_or_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_or_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_sub_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_sub_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_sub_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_sub_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_umax_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_umax_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_umax_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_umax_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_umin_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_umin_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_umin_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_umin_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_xor_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_xor_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_xor_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_xor_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_swap_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_swap_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_swap_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_swap_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_cvtff(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_FF;
    
}
inline bool Predicate_cvtfs(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_FS;
    
}
inline bool Predicate_cvtfu(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_FU;
    
}
inline bool Predicate_cvtsf(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_SF;
    
}
inline bool Predicate_cvtss(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_SS;
    
}
inline bool Predicate_cvtsu(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_SU;
    
}
inline bool Predicate_cvtuf(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_UF;
    
}
inline bool Predicate_cvtus(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_US;
    
}
inline bool Predicate_cvtuu(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_UU;
    
}
inline bool Predicate_extload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::EXTLOAD;

}
inline bool Predicate_extloadf32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_extloadf64(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::f64;

}
inline bool Predicate_extloadi1(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_extloadi16(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_extloadi32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_extloadi8(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_imm16ShiftedSExt(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  // imm16ShiftedSExt predicate - True if only bits in the top 16-bits of the
  // immediate are set.  Used by instructions like 'addis'.  Identical to 
  // imm16ShiftedZExt in 32-bit mode.
  if (N->getZExtValue() & 0xFFFF) return false;
  if (N->getValueType(0) == MVT::i32)
    return true;
  // For 64-bit, make sure it is sext right.
  return N->getZExtValue() == (uint64_t)(int)N->getZExtValue();

}
inline bool Predicate_imm16ShiftedZExt(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  // imm16ShiftedZExt predicate - True if only bits in the top 16-bits of the
  // immediate are set.  Used by instructions like 'xoris'.
  return (N->getZExtValue() & ~uint64_t(0xFFFF0000)) == 0;

}
inline bool Predicate_immAllOnesV(SDNode *N) const {

  return ISD::isBuildVectorAllOnes(N);

}
inline bool Predicate_immAllOnesV_bc(SDNode *N) const {

  return ISD::isBuildVectorAllOnes(N);

}
inline bool Predicate_immAllZerosV(SDNode *N) const {

  return ISD::isBuildVectorAllZeros(N);

}
inline bool Predicate_immAllZerosV_bc(SDNode *N) const {

  return ISD::isBuildVectorAllZeros(N);

}
inline bool Predicate_immSExt16(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  // immSExt16 predicate - True if the immediate fits in a 16-bit sign extended
  // field.  Used by instructions like 'addi'.
  if (N->getValueType(0) == MVT::i32)
    return (int32_t)N->getZExtValue() == (short)N->getZExtValue();
  else
    return (int64_t)N->getZExtValue() == (short)N->getZExtValue();

}
inline bool Predicate_immZExt16(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  // immZExt16 predicate - True if the immediate fits in a 16-bit zero extended
  // field.  Used by instructions like 'ori'.
  return (uint64_t)N->getZExtValue() == (unsigned short)N->getZExtValue();

}
inline bool Predicate_istore(SDNode *N) const {

  return !cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_itruncstore(SDNode *N) const {

  return cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_load(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::NON_EXTLOAD;

}
inline bool Predicate_maskimm32(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  // maskImm predicate - True if immediate is a run of ones.
  unsigned mb, me;
  if (N->getValueType(0) == MVT::i32)
    return isRunOfOnes((unsigned)N->getZExtValue(), mb, me);
  else
    return false;

}
inline bool Predicate_post_store(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::POST_INC || AM == ISD::POST_DEC;

}
inline bool Predicate_post_truncst(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::POST_INC || AM == ISD::POST_DEC;

}
inline bool Predicate_post_truncstf32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_post_truncsti1(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_post_truncsti16(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_post_truncsti32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_post_truncsti8(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_pre_store(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::PRE_INC || AM == ISD::PRE_DEC;

}
inline bool Predicate_pre_truncst(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::PRE_INC || AM == ISD::PRE_DEC;

}
inline bool Predicate_pre_truncstf32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_pre_truncsti1(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_pre_truncsti16(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_pre_truncsti32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_pre_truncsti8(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_sextload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::SEXTLOAD;

}
inline bool Predicate_sextloadi1(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_sextloadi16(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_sextloadi32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_sextloadi8(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_store(SDNode *N) const {

  return !cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_truncstore(SDNode *N) const {

  return cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_truncstoref32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_truncstoref64(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f64;

}
inline bool Predicate_truncstorei16(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_truncstorei32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_truncstorei8(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_unindexedload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getAddressingMode() == ISD::UNINDEXED;

}
inline bool Predicate_unindexedstore(SDNode *N) const {

  return cast<StoreSDNode>(N)->getAddressingMode() == ISD::UNINDEXED;

}
inline bool Predicate_vecspltisb(SDNode *N) const {

  return PPC::get_VSPLTI_elt(N, 1, *CurDAG).getNode() != 0;

}
inline bool Predicate_vecspltish(SDNode *N) const {

  return PPC::get_VSPLTI_elt(N, 2, *CurDAG).getNode() != 0;

}
inline bool Predicate_vecspltisw(SDNode *N) const {

  return PPC::get_VSPLTI_elt(N, 4, *CurDAG).getNode() != 0;

}
inline bool Predicate_vmrghb_shuffle(SDNode *N) const {

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 1, false);

}
inline bool Predicate_vmrghb_unary_shuffle(SDNode *N) const {

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 1, true);

}
inline bool Predicate_vmrghh_shuffle(SDNode *N) const {

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 2, false);

}
inline bool Predicate_vmrghh_unary_shuffle(SDNode *N) const {

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 2, true);

}
inline bool Predicate_vmrghw_shuffle(SDNode *N) const {

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 4, false);

}
inline bool Predicate_vmrghw_unary_shuffle(SDNode *N) const {

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 4, true);

}
inline bool Predicate_vmrglb_shuffle(SDNode *N) const {

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 1, false);

}
inline bool Predicate_vmrglb_unary_shuffle(SDNode *N) const {

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 1, true);

}
inline bool Predicate_vmrglh_shuffle(SDNode *N) const {

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 2, false);

}
inline bool Predicate_vmrglh_unary_shuffle(SDNode *N) const {

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 2, true);

}
inline bool Predicate_vmrglw_shuffle(SDNode *N) const {

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 4, false);

}
inline bool Predicate_vmrglw_unary_shuffle(SDNode *N) const {

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 4, true);

}
inline bool Predicate_vpkuhum_shuffle(SDNode *N) const {

  return PPC::isVPKUHUMShuffleMask(cast<ShuffleVectorSDNode>(N), false);

}
inline bool Predicate_vpkuhum_unary_shuffle(SDNode *N) const {

  return PPC::isVPKUHUMShuffleMask(cast<ShuffleVectorSDNode>(N), true);

}
inline bool Predicate_vpkuwum_shuffle(SDNode *N) const {

  return PPC::isVPKUWUMShuffleMask(cast<ShuffleVectorSDNode>(N), false);

}
inline bool Predicate_vpkuwum_unary_shuffle(SDNode *N) const {

  return PPC::isVPKUWUMShuffleMask(cast<ShuffleVectorSDNode>(N), true);

}
inline bool Predicate_vsldoi_shuffle(SDNode *N) const {

  return PPC::isVSLDOIShuffleMask(N, false) != -1;

}
inline bool Predicate_vsldoi_unary_shuffle(SDNode *N) const {

  return PPC::isVSLDOIShuffleMask(N, true) != -1;

}
inline bool Predicate_vspltb_shuffle(SDNode *N) const {

  return PPC::isSplatShuffleMask(cast<ShuffleVectorSDNode>(N), 1);

}
inline bool Predicate_vsplth_shuffle(SDNode *N) const {

  return PPC::isSplatShuffleMask(cast<ShuffleVectorSDNode>(N), 2);

}
inline bool Predicate_vspltw_shuffle(SDNode *N) const {

  return PPC::isSplatShuffleMask(cast<ShuffleVectorSDNode>(N), 4);

}
inline bool Predicate_vtFP(SDNode *inN) const {
  VTSDNode *N = cast<VTSDNode>(inN);
 return N->getVT().isFloatingPoint(); 
}
inline bool Predicate_vtInt(SDNode *inN) const {
  VTSDNode *N = cast<VTSDNode>(inN);
 return N->getVT().isInteger(); 
}
inline bool Predicate_zextload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::ZEXTLOAD;

}
inline bool Predicate_zextloadi1(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_zextloadi16(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_zextloadi32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_zextloadi8(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i8;

}


// The main instruction selector code.
SDNode *SelectCode(SDNode *N) {
  // Opcodes are emitted as 2 bytes, TARGET_OPCODE handles this.
  #define TARGET_OPCODE(X) X & 255, unsigned(X) >> 8
  static const unsigned char MatcherTable[] = {
          OPC_SwitchOpcode , 37,  ISD::MEMBARRIER,
            OPC_RecordNode,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::Constant,
            OPC_CheckType, MVT::i32,
            OPC_MoveParent,
            OPC_MoveChild, 2,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_MoveChild, 3,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_MoveChild, 4,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_MoveChild, 5,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_EmitMergeInputChains, 1, 0, 
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::SYNC), 0|OPFL_Chain,
                0, 0, 
          114|128,4,  ISD::INTRINSIC_VOID,
            OPC_RecordNode,
            OPC_MoveChild, 1,
            OPC_Scope, 19, 
              OPC_CheckInteger, 80|128,2, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DCBA), 0|OPFL_Chain,
                  0, 2, 2, 3, 
            19, 
              OPC_CheckInteger, 81|128,2, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DCBF), 0|OPFL_Chain,
                  0, 2, 2, 3, 
            19, 
              OPC_CheckInteger, 82|128,2, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DCBI), 0|OPFL_Chain,
                  0, 2, 2, 3, 
            19, 
              OPC_CheckInteger, 83|128,2, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DCBST), 0|OPFL_Chain,
                  0, 2, 2, 3, 
            19, 
              OPC_CheckInteger, 84|128,2, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DCBT), 0|OPFL_Chain,
                  0, 2, 2, 3, 
            19, 
              OPC_CheckInteger, 85|128,2, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DCBTST), 0|OPFL_Chain,
                  0, 2, 2, 3, 
            19, 
              OPC_CheckInteger, 86|128,2, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DCBZ), 0|OPFL_Chain,
                  0, 2, 2, 3, 
            19, 
              OPC_CheckInteger, 87|128,2, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DCBZL), 0|OPFL_Chain,
                  0, 2, 2, 3, 
            21, 
              OPC_CheckInteger, 76|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STVEBX), 0|OPFL_Chain,
                  0, 3, 1, 3, 4, 
            21, 
              OPC_CheckInteger, 77|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STVEHX), 0|OPFL_Chain,
                  0, 3, 1, 3, 4, 
            21, 
              OPC_CheckInteger, 78|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STVEWX), 0|OPFL_Chain,
                  0, 3, 1, 3, 4, 
            21, 
              OPC_CheckInteger, 79|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STVX), 0|OPFL_Chain,
                  0, 3, 1, 3, 4, 
            21, 
              OPC_CheckInteger, 80|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STVXL), 0|OPFL_Chain,
                  0, 3, 1, 3, 4, 
            34, 
              OPC_CheckInteger, 61|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 0, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 0, 
              OPC_EmitInteger, MVT::i32, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DSS), 0|OPFL_Chain,
                  0, 4, 2, 3, 4, 5, 
            63, 
              OPC_CheckInteger, 63|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_Scope, 27, 
                OPC_CheckChild2Type, MVT::i32,
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_MoveChild, 4,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::DST), 0|OPFL_Chain,
                    0, 4, 4, 5, 1, 2, 
              27, 
                OPC_CheckChild2Type, MVT::i64,
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_MoveChild, 4,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::DST64), 0|OPFL_Chain,
                    0, 4, 4, 5, 1, 2, 
              0, 
            63, 
              OPC_CheckInteger, 66|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_Scope, 27, 
                OPC_CheckChild2Type, MVT::i32,
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_MoveChild, 4,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::DSTT), 0|OPFL_Chain,
                    0, 4, 4, 5, 1, 2, 
              27, 
                OPC_CheckChild2Type, MVT::i64,
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_MoveChild, 4,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::DSTT64), 0|OPFL_Chain,
                    0, 4, 4, 5, 1, 2, 
              0, 
            63, 
              OPC_CheckInteger, 64|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_Scope, 27, 
                OPC_CheckChild2Type, MVT::i32,
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_MoveChild, 4,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::DSTST), 0|OPFL_Chain,
                    0, 4, 4, 5, 1, 2, 
              27, 
                OPC_CheckChild2Type, MVT::i64,
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_MoveChild, 4,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::DSTST64), 0|OPFL_Chain,
                    0, 4, 4, 5, 1, 2, 
              0, 
            63, 
              OPC_CheckInteger, 65|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_Scope, 27, 
                OPC_CheckChild2Type, MVT::i32,
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_MoveChild, 4,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::DSTSTT), 0|OPFL_Chain,
                    0, 4, 4, 5, 1, 2, 
              27, 
                OPC_CheckChild2Type, MVT::i64,
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_MoveChild, 4,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::DSTSTT64), 0|OPFL_Chain,
                    0, 4, 4, 5, 1, 2, 
              0, 
            13, 
              OPC_CheckInteger, 88|128,2, 
              OPC_MoveParent,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::SYNC), 0|OPFL_Chain,
                  0, 0, 
            15, 
              OPC_CheckInteger, 75|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::MTVSCR), 0|OPFL_Chain,
                  0, 1, 1, 
            29, 
              OPC_CheckInteger, 62|128,1, 
              OPC_MoveParent,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 1, 
              OPC_EmitInteger, MVT::i32, 0, 
              OPC_EmitInteger, MVT::i32, 0, 
              OPC_EmitInteger, MVT::i32, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DSSALL), 0|OPFL_Chain,
                  0, 4, 1, 2, 3, 4, 
            0, 
          125,  ISD::INTRINSIC_W_CHAIN,
            OPC_RecordNode,
            OPC_MoveChild, 1,
            OPC_Scope, 20, 
              OPC_CheckInteger, 67|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LVEBX), 0|OPFL_Chain,
                  1, MVT::v16i8, 2, 2, 3, 
            20, 
              OPC_CheckInteger, 68|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LVEHX), 0|OPFL_Chain,
                  1, MVT::v8i16, 2, 2, 3, 
            20, 
              OPC_CheckInteger, 69|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LVEWX), 0|OPFL_Chain,
                  1, MVT::v4i32, 2, 2, 3, 
            20, 
              OPC_CheckInteger, 72|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LVX), 0|OPFL_Chain,
                  1, MVT::v4i32, 2, 2, 3, 
            20, 
              OPC_CheckInteger, 73|128,1, 
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LVXL), 0|OPFL_Chain,
                  1, MVT::v4i32, 2, 2, 3, 
            14, 
              OPC_CheckInteger, 74|128,1, 
              OPC_MoveParent,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::MFVSCR), 0|OPFL_Chain,
                  1, MVT::v8i16, 0, 
            0, 
          18|128,13,  ISD::INTRINSIC_WO_CHAIN,
            OPC_MoveChild, 0,
            OPC_Scope, 17, 
              OPC_CheckInteger, 70|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckComplexPat, /*CP*/0, /*#*/0,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LVSL), 0,
                  1, MVT::v16i8, 2, 1, 2, 
            17, 
              OPC_CheckInteger, 71|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckComplexPat, /*CP*/0, /*#*/0,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LVSR), 0,
                  1, MVT::v16i8, 2, 1, 2, 
            22, 
              OPC_CheckInteger, 94|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCFSX), 0,
                  1, MVT::v4f32, 2, 2, 0, 
            22, 
              OPC_CheckInteger, 95|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCFUX), 0,
                  1, MVT::v4f32, 2, 2, 0, 
            22, 
              OPC_CheckInteger, 122|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCTSXS), 0,
                  1, MVT::v4i32, 2, 2, 0, 
            22, 
              OPC_CheckInteger, 123|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCTUXS), 0,
                  1, MVT::v4i32, 2, 2, 0, 
            17, 
              OPC_CheckInteger, 6|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMHADDSHS), 0,
                  1, MVT::v8i16, 3, 0, 1, 2, 
            17, 
              OPC_CheckInteger, 7|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMHRADDSHS), 0,
                  1, MVT::v8i16, 3, 0, 1, 2, 
            17, 
              OPC_CheckInteger, 15|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMLADDUHM), 0,
                  1, MVT::v8i16, 3, 0, 1, 2, 
            17, 
              OPC_CheckInteger, 31|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPERM), 0,
                  1, MVT::v4i32, 3, 0, 1, 2, 
            17, 
              OPC_CheckInteger, 48|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSEL), 0,
                  1, MVT::v4i32, 3, 0, 1, 2, 
            15, 
              OPC_CheckInteger, 81|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VADDCUW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 82|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VADDSBS), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 83|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VADDSHS), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 84|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VADDSWS), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 85|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VADDUBS), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 86|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VADDUHS), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 87|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VADDUWS), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            13, 
              OPC_CheckInteger, 124|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VEXPTEFP), 0,
                  1, MVT::v4f32, 1, 0, 
            13, 
              OPC_CheckInteger, 125|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VLOGEFP), 0,
                  1, MVT::v4f32, 1, 0, 
            15, 
              OPC_CheckInteger, 88|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VAVGSB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 89|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VAVGSH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 90|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VAVGSW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 91|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VAVGUB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 92|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VAVGUH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 93|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VAVGUW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 127|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMAXFP), 0,
                  1, MVT::v4f32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 0|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMAXSB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 1|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMAXSH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 2|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMAXSW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 3|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMAXUB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 4|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMAXUH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 5|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMAXUW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 8|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMINFP), 0,
                  1, MVT::v4f32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 9|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMINSB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 10|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMINSH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 11|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMINSW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 12|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMINUB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 13|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMINUH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 14|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMINUW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            17, 
              OPC_CheckInteger, 16|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMSUMMBM), 0,
                  1, MVT::v4i32, 3, 0, 1, 2, 
            17, 
              OPC_CheckInteger, 17|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMSUMSHM), 0,
                  1, MVT::v4i32, 3, 0, 1, 2, 
            17, 
              OPC_CheckInteger, 18|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMSUMSHS), 0,
                  1, MVT::v4i32, 3, 0, 1, 2, 
            17, 
              OPC_CheckInteger, 19|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMSUMUBM), 0,
                  1, MVT::v4i32, 3, 0, 1, 2, 
            17, 
              OPC_CheckInteger, 20|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMSUMUHM), 0,
                  1, MVT::v4i32, 3, 0, 1, 2, 
            17, 
              OPC_CheckInteger, 21|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMSUMUHS), 0,
                  1, MVT::v4i32, 3, 0, 1, 2, 
            15, 
              OPC_CheckInteger, 22|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMULESB), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 23|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMULESH), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 24|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMULEUB), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 25|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMULEUH), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 26|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMULOSB), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 27|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMULOSH), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 28|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMULOUB), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 29|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMULOUH), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            13, 
              OPC_CheckInteger, 39|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VREFP), 0,
                  1, MVT::v4f32, 1, 0, 
            13, 
              OPC_CheckInteger, 40|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VRFIM), 0,
                  1, MVT::v4f32, 1, 0, 
            13, 
              OPC_CheckInteger, 41|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VRFIN), 0,
                  1, MVT::v4f32, 1, 0, 
            13, 
              OPC_CheckInteger, 42|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VRFIP), 0,
                  1, MVT::v4f32, 1, 0, 
            13, 
              OPC_CheckInteger, 43|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VRFIZ), 0,
                  1, MVT::v4f32, 1, 0, 
            13, 
              OPC_CheckInteger, 47|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VRSQRTEFP), 0,
                  1, MVT::v4f32, 1, 0, 
            15, 
              OPC_CheckInteger, 62|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUBCUW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 63|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUBSBS), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 64|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUBSHS), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 65|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUBSWS), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 66|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUBUBS), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 67|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUBUHS), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 68|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUBUWS), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 73|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUMSWS), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 69|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUM2SWS), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 70|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUM4SBS), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 71|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUM4SHS), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 72|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUM4UBS), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 44|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VRLB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 45|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VRLH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 46|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VRLW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 49|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSL), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 52|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSLO), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 50|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSLB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 51|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSLH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 53|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSLW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 54|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSR), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 60|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRO), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 55|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRAB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 56|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRAH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 57|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRAW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 58|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 59|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 61|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 32|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPKPX), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 33|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPKSHSS), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 34|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPKSHUS), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 35|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPKSWSS), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 36|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPKSWUS), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 37|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPKUHUS), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 38|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPKUWUS), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            13, 
              OPC_CheckInteger, 74|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VUPKHPX), 0,
                  1, MVT::v4i32, 1, 0, 
            13, 
              OPC_CheckInteger, 75|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VUPKHSB), 0,
                  1, MVT::v8i16, 1, 0, 
            13, 
              OPC_CheckInteger, 76|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VUPKHSH), 0,
                  1, MVT::v4i32, 1, 0, 
            13, 
              OPC_CheckInteger, 77|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VUPKLPX), 0,
                  1, MVT::v4i32, 1, 0, 
            13, 
              OPC_CheckInteger, 78|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VUPKLSB), 0,
                  1, MVT::v8i16, 1, 0, 
            13, 
              OPC_CheckInteger, 79|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VUPKLSH), 0,
                  1, MVT::v4i32, 1, 0, 
            17, 
              OPC_CheckInteger, 126|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMADDFP), 0,
                  1, MVT::v4f32, 3, 0, 1, 2, 
            17, 
              OPC_CheckInteger, 30|128,2, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VNMSUBFP), 0,
                  1, MVT::v4f32, 3, 0, 1, 2, 
            0, 
          17|128,4,  ISD::ADD,
            OPC_Scope, 42|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 23,  PPCISD::Lo,
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::TargetGlobalAddress,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LA), 0,
                    1, MVT::i32, 2, 0, 1, 
              9|128,1,  PPCISD::Hi,
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 31,  ISD::TargetGlobalAddress,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_SwitchType , 9,  MVT::i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS), 0,
                        1, MVT::i32, 2, 0, 1, 
                  9,  MVT::i64,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS8), 0,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                31,  ISD::TargetConstantPool,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_SwitchType , 9,  MVT::i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS), 0,
                        1, MVT::i32, 2, 0, 1, 
                  9,  MVT::i64,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS8), 0,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                31,  ISD::TargetJumpTable,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_SwitchType , 9,  MVT::i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS), 0,
                        1, MVT::i32, 2, 0, 1, 
                  9,  MVT::i64,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS8), 0,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                31,  ISD::TargetBlockAddress,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_SwitchType , 9,  MVT::i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS), 0,
                        1, MVT::i32, 2, 0, 1, 
                  9,  MVT::i64,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS8), 0,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                0, 
              0, 
            46|128,1, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 24,  PPCISD::Lo,
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::TargetGlobalAddress,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LA), 0,
                    1, MVT::i32, 2, 1, 0, 
              13|128,1,  PPCISD::Hi,
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 32,  ISD::TargetGlobalAddress,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_SwitchType , 9,  MVT::i64,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS8), 0,
                        1, MVT::i64, 2, 1, 0, 
                  9,  MVT::i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS), 0,
                        1, MVT::i32, 2, 1, 0, 
                  0, 
                32,  ISD::TargetConstantPool,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_SwitchType , 9,  MVT::i64,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS8), 0,
                        1, MVT::i64, 2, 1, 0, 
                  9,  MVT::i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS), 0,
                        1, MVT::i32, 2, 1, 0, 
                  0, 
                32,  ISD::TargetJumpTable,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_SwitchType , 9,  MVT::i64,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS8), 0,
                        1, MVT::i64, 2, 1, 0, 
                  9,  MVT::i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS), 0,
                        1, MVT::i32, 2, 1, 0, 
                  0, 
                32,  ISD::TargetBlockAddress,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_SwitchType , 9,  MVT::i64,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS8), 0,
                        1, MVT::i64, 2, 1, 0, 
                  9,  MVT::i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS), 0,
                        1, MVT::i32, 2, 1, 0, 
                  0, 
                0, 
              0, 
            49|128,1, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 112, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 16, 
                  OPC_CheckPredicate, 0,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDI), 0,
                      1, MVT::i32, 2, 0, 2, 
                19, 
                  OPC_CheckPredicate, 1,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 0, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS), 0,
                      1, MVT::i32, 2, 0, 3, 
                16, 
                  OPC_CheckPredicate, 0,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDI8), 0,
                      1, MVT::i64, 2, 0, 2, 
                19, 
                  OPC_CheckPredicate, 1,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 0, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS8), 0,
                      1, MVT::i64, 2, 0, 3, 
                31, 
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 1, 2,
                  OPC_EmitNode, TARGET_OPCODE(PPC::ADDI), 0,
                      1, MVT::i32, 2, 0, 3, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 2, 5,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIS), 0,
                      1, MVT::i32, 2, 4, 6, 
                0, 
              11, 
                OPC_CheckType, MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADD4), 0,
                    1, MVT::i32, 2, 0, 1, 
              11, 
                OPC_CheckType, MVT::v16i8,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VADDUBM), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              11, 
                OPC_CheckType, MVT::v8i16,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VADDUHM), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              11, 
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VADDUWM), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              11, 
                OPC_CheckType, MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADD8), 0,
                    1, MVT::i64, 2, 0, 1, 
              0, 
            0, 
          27|128,7,  ISD::LOAD,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_CheckPredicate, 2,
            OPC_Scope, 21, 
              OPC_CheckPredicate, 3,
              OPC_CheckPredicate, 4,
              OPC_CheckType, MVT::i32,
              OPC_CheckComplexPat, /*CP*/1, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZ), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i32, 2, 2, 3, 
            21, 
              OPC_CheckPredicate, 5,
              OPC_CheckPredicate, 6,
              OPC_CheckType, MVT::i32,
              OPC_CheckComplexPat, /*CP*/1, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHA), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i32, 2, 2, 3, 
            21, 
              OPC_CheckPredicate, 3,
              OPC_CheckPredicate, 7,
              OPC_CheckType, MVT::i32,
              OPC_CheckComplexPat, /*CP*/1, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHZ), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i32, 2, 2, 3, 
            55, 
              OPC_CheckPredicate, 8,
              OPC_SwitchType , 15,  MVT::i32,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LWZ), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 2, 2, 3, 
              15,  MVT::f32,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LFS), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::f32, 2, 2, 3, 
              15,  MVT::f64,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LFD), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::f64, 2, 2, 3, 
              0, 
            21, 
              OPC_CheckPredicate, 3,
              OPC_CheckPredicate, 4,
              OPC_CheckType, MVT::i32,
              OPC_CheckComplexPat, /*CP*/2, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZX), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i32, 2, 2, 3, 
            21, 
              OPC_CheckPredicate, 5,
              OPC_CheckPredicate, 6,
              OPC_CheckType, MVT::i32,
              OPC_CheckComplexPat, /*CP*/2, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHAX), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i32, 2, 2, 3, 
            21, 
              OPC_CheckPredicate, 3,
              OPC_CheckPredicate, 7,
              OPC_CheckType, MVT::i32,
              OPC_CheckComplexPat, /*CP*/2, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHZX), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i32, 2, 2, 3, 
            55, 
              OPC_CheckPredicate, 8,
              OPC_SwitchType , 15,  MVT::i32,
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LWZX), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 2, 2, 3, 
              15,  MVT::f32,
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LFSX), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::f32, 2, 2, 3, 
              15,  MVT::f64,
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LFDX), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::f64, 2, 2, 3, 
              0, 
            40, 
              OPC_CheckPredicate, 3,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i32,
              OPC_Scope, 15, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZ), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 2, 2, 3, 
              15, 
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZX), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 2, 2, 3, 
              0, 
            117, 
              OPC_CheckPredicate, 10,
              OPC_CheckType, MVT::i32,
              OPC_Scope, 36, 
                OPC_CheckPredicate, 11,
                OPC_Scope, 15, 
                  OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZ), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 2, 2, 3, 
                15, 
                  OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZX), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 2, 2, 3, 
                0, 
              36, 
                OPC_CheckPredicate, 12,
                OPC_Scope, 15, 
                  OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZ), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 2, 2, 3, 
                15, 
                  OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZX), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 2, 2, 3, 
                0, 
              36, 
                OPC_CheckPredicate, 13,
                OPC_Scope, 15, 
                  OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHZ), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 2, 2, 3, 
                15, 
                  OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHZX), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 2, 2, 3, 
                0, 
              0, 
            19, 
              OPC_CheckPredicate, 8,
              OPC_CheckType, MVT::v4i32,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LVX), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::v4i32, 2, 2, 3, 
            78, 
              OPC_CheckPredicate, 5,
              OPC_CheckType, MVT::i64,
              OPC_Scope, 17, 
                OPC_CheckPredicate, 6,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHA8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              17, 
                OPC_CheckPredicate, 14,
                OPC_CheckComplexPat, /*CP*/3, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LWA), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              17, 
                OPC_CheckPredicate, 6,
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHAX8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              17, 
                OPC_CheckPredicate, 14,
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LWAX), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              0, 
            114, 
              OPC_CheckPredicate, 3,
              OPC_CheckType, MVT::i64,
              OPC_Scope, 17, 
                OPC_CheckPredicate, 4,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZ8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              17, 
                OPC_CheckPredicate, 7,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHZ8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              17, 
                OPC_CheckPredicate, 15,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LWZ8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              17, 
                OPC_CheckPredicate, 4,
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZX8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              17, 
                OPC_CheckPredicate, 7,
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHZX8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              17, 
                OPC_CheckPredicate, 15,
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LWZX8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              0, 
            38, 
              OPC_CheckPredicate, 8,
              OPC_CheckType, MVT::i64,
              OPC_Scope, 15, 
                OPC_CheckComplexPat, /*CP*/3, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LD), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              15, 
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LDX), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              0, 
            40, 
              OPC_CheckPredicate, 3,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i64,
              OPC_Scope, 15, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZ8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              15, 
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZX8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 2, 2, 3, 
              0, 
            89|128,1, 
              OPC_CheckPredicate, 10,
              OPC_SwitchType , 22|128,1,  MVT::i64,
                OPC_Scope, 36, 
                  OPC_CheckPredicate, 11,
                  OPC_Scope, 15, 
                    OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZ8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i64, 2, 2, 3, 
                  15, 
                    OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZX8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i64, 2, 2, 3, 
                  0, 
                36, 
                  OPC_CheckPredicate, 12,
                  OPC_Scope, 15, 
                    OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZ8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i64, 2, 2, 3, 
                  15, 
                    OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::LBZX8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i64, 2, 2, 3, 
                  0, 
                36, 
                  OPC_CheckPredicate, 13,
                  OPC_Scope, 15, 
                    OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHZ8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i64, 2, 2, 3, 
                  15, 
                    OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHZX8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i64, 2, 2, 3, 
                  0, 
                36, 
                  OPC_CheckPredicate, 16,
                  OPC_Scope, 15, 
                    OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::LWZ8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i64, 2, 2, 3, 
                  15, 
                    OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::LWZX8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i64, 2, 2, 3, 
                  0, 
                0, 
              58,  MVT::f64,
                OPC_CheckPredicate, 17,
                OPC_Scope, 26, 
                  OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitNode, TARGET_OPCODE(PPC::LFS), 0|OPFL_Chain,
                      1, MVT::f32, 2, 2, 3, 
                  OPC_EmitNode, TARGET_OPCODE(PPC::FMRSD), 0|OPFL_MemRefs,
                      1, MVT::f64, 1, 4, 
                  OPC_CompleteMatch, 1, 5, 

                26, 
                  OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitNode, TARGET_OPCODE(PPC::LFSX), 0|OPFL_Chain,
                      1, MVT::f32, 2, 2, 3, 
                  OPC_EmitNode, TARGET_OPCODE(PPC::FMRSD), 0|OPFL_MemRefs,
                      1, MVT::f64, 1, 4, 
                  OPC_CompleteMatch, 1, 5, 

                0, 
              0, 
            0, 
          83|128,4,  ISD::STORE,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_Scope, 70|128,1, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_RecordChild2,
              OPC_Scope, 122, 
                OPC_CheckPredicate, 18,
                OPC_Scope, 40, 
                  OPC_CheckPredicate, 19,
                  OPC_Scope, 17, 
                    OPC_CheckPredicate, 20,
                    OPC_CheckComplexPat, /*CP*/1, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STB), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  17, 
                    OPC_CheckPredicate, 21,
                    OPC_CheckComplexPat, /*CP*/1, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STH), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  0, 
                17, 
                  OPC_CheckPredicate, 22,
                  OPC_CheckComplexPat, /*CP*/1, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::STW), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 3, 1, 3, 4, 
                40, 
                  OPC_CheckPredicate, 19,
                  OPC_Scope, 17, 
                    OPC_CheckPredicate, 20,
                    OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STBX), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  17, 
                    OPC_CheckPredicate, 21,
                    OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STHX), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  0, 
                17, 
                  OPC_CheckPredicate, 22,
                  OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::STWX), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 3, 1, 3, 4, 
                0, 
              69, 
                OPC_RecordChild3,
                OPC_Scope, 44, 
                  OPC_CheckPredicate, 23,
                  OPC_CheckPredicate, 24,
                  OPC_Scope, 18, 
                    OPC_CheckPredicate, 25,
                    OPC_CheckComplexPat, /*CP*/4, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STBU), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::iPTR, 3, 1, 4, 2, 
                  18, 
                    OPC_CheckPredicate, 26,
                    OPC_CheckComplexPat, /*CP*/4, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STHU), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::iPTR, 3, 1, 4, 2, 
                  0, 
                20, 
                  OPC_CheckPredicate, 27,
                  OPC_CheckPredicate, 28,
                  OPC_CheckComplexPat, /*CP*/4, /*#*/3,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::STWU), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::iPTR, 3, 1, 4, 2, 
                0, 
              0, 
            66, 
              OPC_CheckChild1Type, MVT::f32,
              OPC_RecordChild2,
              OPC_Scope, 38, 
                OPC_CheckPredicate, 18,
                OPC_CheckPredicate, 22,
                OPC_Scope, 15, 
                  OPC_CheckComplexPat, /*CP*/1, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::STFS), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 3, 1, 3, 4, 
                15, 
                  OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::STFSX), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 3, 1, 3, 4, 
                0, 
              21, 
                OPC_RecordChild3,
                OPC_CheckPredicate, 27,
                OPC_CheckPredicate, 28,
                OPC_CheckComplexPat, /*CP*/4, /*#*/3,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::STFSU), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::iPTR, 3, 1, 4, 2, 
              0, 
            66, 
              OPC_CheckChild1Type, MVT::f64,
              OPC_RecordChild2,
              OPC_Scope, 38, 
                OPC_CheckPredicate, 18,
                OPC_CheckPredicate, 22,
                OPC_Scope, 15, 
                  OPC_CheckComplexPat, /*CP*/1, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::STFD), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 3, 1, 3, 4, 
                15, 
                  OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::STFDX), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 3, 1, 3, 4, 
                0, 
              21, 
                OPC_RecordChild3,
                OPC_CheckPredicate, 27,
                OPC_CheckPredicate, 28,
                OPC_CheckComplexPat, /*CP*/4, /*#*/3,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::STFDU), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::iPTR, 3, 1, 4, 2, 
              0, 
            22, 
              OPC_CheckChild1Type, MVT::v4i32,
              OPC_RecordChild2,
              OPC_CheckPredicate, 18,
              OPC_CheckPredicate, 22,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STVX), 0|OPFL_Chain|OPFL_MemRefs,
                  0, 3, 1, 3, 4, 
            103|128,1, 
              OPC_CheckChild1Type, MVT::i64,
              OPC_RecordChild2,
              OPC_Scope, 26|128,1, 
                OPC_CheckPredicate, 18,
                OPC_Scope, 112, 
                  OPC_CheckPredicate, 19,
                  OPC_Scope, 17, 
                    OPC_CheckPredicate, 20,
                    OPC_CheckComplexPat, /*CP*/1, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STB8), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  17, 
                    OPC_CheckPredicate, 21,
                    OPC_CheckComplexPat, /*CP*/1, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STH8), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  17, 
                    OPC_CheckPredicate, 29,
                    OPC_CheckComplexPat, /*CP*/1, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STW8), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  17, 
                    OPC_CheckPredicate, 20,
                    OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STBX8), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  17, 
                    OPC_CheckPredicate, 21,
                    OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STHX8), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  17, 
                    OPC_CheckPredicate, 29,
                    OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STWX8), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  0, 
                36, 
                  OPC_CheckPredicate, 22,
                  OPC_Scope, 15, 
                    OPC_CheckComplexPat, /*CP*/3, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STD), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  15, 
                    OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STDX), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 3, 1, 3, 4, 
                  0, 
                0, 
              69, 
                OPC_RecordChild3,
                OPC_Scope, 44, 
                  OPC_CheckPredicate, 23,
                  OPC_CheckPredicate, 24,
                  OPC_Scope, 18, 
                    OPC_CheckPredicate, 25,
                    OPC_CheckComplexPat, /*CP*/4, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STBU8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::iPTR, 3, 1, 4, 2, 
                  18, 
                    OPC_CheckPredicate, 26,
                    OPC_CheckComplexPat, /*CP*/4, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::STHU8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::iPTR, 3, 1, 4, 2, 
                  0, 
                20, 
                  OPC_CheckPredicate, 27,
                  OPC_CheckPredicate, 28,
                  OPC_CheckComplexPat, /*CP*/4, /*#*/3,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::STDU), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::iPTR, 3, 1, 4, 2, 
                0, 
              0, 
            0, 
          26|128,1,  ISD::FSUB,
            OPC_Scope, 72, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 30,  ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 30,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::FSUB,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::FMUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4f32,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VNMSUBFP), 0,
                    1, MVT::v4f32, 3, 0, 1, 2, 
              34,  ISD::FMUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 12,  MVT::f64,
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FMSUB), 0,
                      1, MVT::f64, 3, 0, 1, 2, 
                12,  MVT::f32,
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FMSUBS), 0,
                      1, MVT::f32, 3, 0, 1, 2, 
                0, 
              0, 
            78, 
              OPC_RecordChild0,
              OPC_Scope, 37, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::FMUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_SwitchType , 12,  MVT::f64,
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNMSUB), 0,
                      1, MVT::f64, 3, 1, 2, 0, 
                12,  MVT::f32,
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNMSUBS), 0,
                      1, MVT::f32, 3, 1, 2, 0, 
                0, 
              36, 
                OPC_RecordChild1,
                OPC_SwitchType , 9,  MVT::f64,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FSUB), 0,
                      1, MVT::f64, 2, 0, 1, 
                9,  MVT::f32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FSUBS), 0,
                      1, MVT::f32, 2, 0, 1, 
                9,  MVT::v4f32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUBFP), 0,
                      1, MVT::v4f32, 2, 0, 1, 
                0, 
              0, 
            0, 
          87,  ISD::ATOMIC_LOAD_ADD,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_SwitchType , 59,  MVT::i32,
              OPC_Scope, 18, 
                OPC_CheckPredicate, 31,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_ADD_I8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_ADD_I16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 33,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              0, 
            18,  MVT::i64,
              OPC_CheckPredicate, 34,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 3, 3, 4, 2, 
            0, 
          87,  ISD::ATOMIC_LOAD_SUB,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_SwitchType , 59,  MVT::i32,
              OPC_Scope, 18, 
                OPC_CheckPredicate, 35,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_SUB_I8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 36,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_SUB_I16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 37,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              0, 
            18,  MVT::i64,
              OPC_CheckPredicate, 38,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 3, 3, 4, 2, 
            0, 
          87,  ISD::ATOMIC_LOAD_AND,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_SwitchType , 59,  MVT::i32,
              OPC_Scope, 18, 
                OPC_CheckPredicate, 39,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_AND_I8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 40,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_AND_I16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 41,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              0, 
            18,  MVT::i64,
              OPC_CheckPredicate, 42,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 3, 3, 4, 2, 
            0, 
          87,  ISD::ATOMIC_LOAD_OR,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_SwitchType , 59,  MVT::i32,
              OPC_Scope, 18, 
                OPC_CheckPredicate, 43,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_OR_I8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 44,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_OR_I16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 45,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              0, 
            18,  MVT::i64,
              OPC_CheckPredicate, 46,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 3, 3, 4, 2, 
            0, 
          87,  ISD::ATOMIC_LOAD_XOR,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_SwitchType , 59,  MVT::i32,
              OPC_Scope, 18, 
                OPC_CheckPredicate, 47,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_XOR_I8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 48,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_XOR_I16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 49,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              0, 
            18,  MVT::i64,
              OPC_CheckPredicate, 50,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 3, 3, 4, 2, 
            0, 
          87,  ISD::ATOMIC_LOAD_NAND,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_SwitchType , 59,  MVT::i32,
              OPC_Scope, 18, 
                OPC_CheckPredicate, 51,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_NAND_I8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 52,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_NAND_I16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 53,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_NAND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              0, 
            18,  MVT::i64,
              OPC_CheckPredicate, 54,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_LOAD_NAND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 3, 3, 4, 2, 
            0, 
          92,  ISD::ATOMIC_CMP_SWAP,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_RecordChild3,
            OPC_SwitchType , 62,  MVT::i32,
              OPC_Scope, 19, 
                OPC_CheckPredicate, 55,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_CMP_SWAP_I8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 4, 4, 5, 2, 3, 
              19, 
                OPC_CheckPredicate, 56,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_CMP_SWAP_I16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 4, 4, 5, 2, 3, 
              19, 
                OPC_CheckPredicate, 57,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_CMP_SWAP_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 4, 4, 5, 2, 3, 
              0, 
            19,  MVT::i64,
              OPC_CheckPredicate, 58,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_CMP_SWAP_I64), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 4, 4, 5, 2, 3, 
            0, 
          87,  ISD::ATOMIC_SWAP,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_SwitchType , 59,  MVT::i32,
              OPC_Scope, 18, 
                OPC_CheckPredicate, 59,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_SWAP_I8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 60,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_SWAP_I16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              18, 
                OPC_CheckPredicate, 61,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_SWAP_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 3, 4, 2, 
              0, 
            18,  MVT::i64,
              OPC_CheckPredicate, 62,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::ATOMIC_SWAP_I64), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 3, 3, 4, 2, 
            0, 
          50,  PPCISD::DYNALLOC,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_SwitchType , 21,  MVT::i32,
              OPC_CheckChild1Type, MVT::i32,
              OPC_RecordChild2,
              OPC_CheckChild2Type, MVT::iPTR,
              OPC_CheckComplexPat, /*CP*/1, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DYNALLOC), 0|OPFL_Chain,
                  1, MVT::i32, 3, 1, 3, 4, 
            21,  MVT::i64,
              OPC_CheckChild1Type, MVT::i64,
              OPC_RecordChild2,
              OPC_CheckChild2Type, MVT::iPTR,
              OPC_CheckComplexPat, /*CP*/1, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DYNALLOC8), 0|OPFL_Chain,
                  1, MVT::i64, 3, 1, 3, 4, 
            0, 
          38,  PPCISD::LARX,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_SwitchType , 15,  MVT::i32,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LWARX), 0|OPFL_Chain,
                  1, MVT::i32, 2, 2, 3, 
            15,  MVT::i64,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LDARX), 0|OPFL_Chain,
                  1, MVT::i64, 2, 2, 3, 
            0, 
          42,  PPCISD::STCX,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_Scope, 18, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STWCX), 0|OPFL_Chain,
                  0, 3, 1, 3, 4, 
            18, 
              OPC_CheckChild1Type, MVT::i64,
              OPC_RecordChild2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STDCX), 0|OPFL_Chain,
                  0, 3, 1, 3, 4, 
            0, 
          44,  PPCISD::LBRX,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_MoveChild, 2,
            OPC_Scope, 18, 
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LHBRX), 0|OPFL_Chain,
                  1, MVT::i32, 2, 2, 3, 
            18, 
              OPC_CheckValueType, MVT::i32,
              OPC_MoveParent,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LWBRX), 0|OPFL_Chain,
                  1, MVT::i32, 2, 2, 3, 
            0, 
          45,  PPCISD::STBRX,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_MoveChild, 3,
            OPC_Scope, 18, 
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STHBRX), 0|OPFL_Chain,
                  0, 3, 1, 3, 4, 
            18, 
              OPC_CheckValueType, MVT::i32,
              OPC_MoveParent,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STWBRX), 0|OPFL_Chain,
                  0, 3, 1, 3, 4, 
            0, 
          18,  PPCISD::STFIWX,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_CheckComplexPat, /*CP*/0, /*#*/2,
            OPC_EmitMergeInputChains, 1, 0, 
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::STFIWX), 0|OPFL_Chain,
                0, 3, 1, 3, 4, 
          41,  PPCISD::LOAD,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_RecordChild1,
            OPC_CheckChild1Type, MVT::iPTR,
            OPC_CheckType, MVT::i64,
            OPC_Scope, 15, 
              OPC_CheckComplexPat, /*CP*/3, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LD), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i64, 2, 2, 3, 
            15, 
              OPC_CheckComplexPat, /*CP*/2, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::LDX), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i64, 2, 2, 3, 
            0, 
          39,  PPCISD::STD_32,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_CheckChild1Type, MVT::i32,
            OPC_RecordChild2,
            OPC_Scope, 15, 
              OPC_CheckComplexPat, /*CP*/3, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STD_32), 0|OPFL_Chain,
                  0, 3, 1, 3, 4, 
            15, 
              OPC_CheckComplexPat, /*CP*/2, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::STDX_32), 0|OPFL_Chain,
                  0, 3, 1, 3, 4, 
            0, 
          127|128,4,  ISD::XOR,
            OPC_Scope, 36|128,1, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 41,  ISD::AND,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_SwitchType , 9,  MVT::i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::NAND), 0,
                      1, MVT::i32, 2, 0, 1, 
                9,  MVT::i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::NAND8), 0,
                      1, MVT::i64, 2, 0, 1, 
                0, 
              41,  ISD::OR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_SwitchType , 9,  MVT::i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::NOR), 0,
                      1, MVT::i32, 2, 0, 1, 
                9,  MVT::i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::NOR8), 0,
                      1, MVT::i64, 2, 0, 1, 
                0, 
              72,  ISD::XOR,
                OPC_RecordChild0,
                OPC_Scope, 40, 
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                  OPC_MoveParent,
                  OPC_SwitchType , 9,  MVT::i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::EQV), 0,
                        1, MVT::i32, 2, 0, 1, 
                  9,  MVT::i64,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::EQV8), 0,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                27, 
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::EQV), 0,
                      1, MVT::i32, 2, 0, 1, 
                0, 
              0, 
            32, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::EQV), 0,
                  1, MVT::i32, 2, 1, 0, 
            32, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::EQV8), 0,
                  1, MVT::i64, 2, 0, 1, 
            32, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::EQV8), 0,
                  1, MVT::i64, 2, 1, 0, 
            91, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 39,  ISD::OR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_SwitchOpcode , 14,  ISD::BUILD_VECTOR,
                  OPC_CheckPredicate, 63,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VNOR), 0,
                      1, MVT::v4i32, 2, 0, 1, 
                14,  ISD::BIT_CONVERT,
                  OPC_CheckPredicate, 64,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VNOR), 0,
                      1, MVT::v4i32, 2, 0, 1, 
                0, 
              21,  ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 63,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::OR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VNOR), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              21,  ISD::BIT_CONVERT,
                OPC_CheckPredicate, 64,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::OR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VNOR), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            34|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 25, 
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::NOR), 0,
                    1, MVT::i32, 2, 0, 0, 
              47, 
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 19, 
                  OPC_CheckPredicate, 65,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 1, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::XORI), 0,
                      1, MVT::i32, 2, 0, 3, 
                19, 
                  OPC_CheckPredicate, 66,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 0, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::XORIS), 0,
                      1, MVT::i32, 2, 0, 3, 
                0, 
              36, 
                OPC_MoveChild, 1,
                OPC_SwitchOpcode , 14,  ISD::BUILD_VECTOR,
                  OPC_CheckPredicate, 63,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VNOR), 0,
                      1, MVT::v4i32, 2, 0, 0, 
                14,  ISD::BIT_CONVERT,
                  OPC_CheckPredicate, 64,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VNOR), 0,
                      1, MVT::v4i32, 2, 0, 0, 
                0, 
              47, 
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 19, 
                  OPC_CheckPredicate, 65,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 1, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::XORI8), 0,
                      1, MVT::i64, 2, 0, 3, 
                19, 
                  OPC_CheckPredicate, 66,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 0, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::XORIS8), 0,
                      1, MVT::i64, 2, 0, 3, 
                0, 
              0, 
            38, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 15,  ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 63,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VNOR), 0,
                    1, MVT::v4i32, 2, 0, 0, 
              15,  ISD::BIT_CONVERT,
                OPC_CheckPredicate, 64,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VNOR), 0,
                    1, MVT::v4i32, 2, 0, 0, 
              0, 
            76, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 1, 2,
                OPC_EmitNode, TARGET_OPCODE(PPC::XORI), 0,
                    1, MVT::i32, 2, 0, 3, 
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 0, 5,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::XORIS), 0,
                    1, MVT::i32, 2, 4, 6, 
              11, 
                OPC_CheckType, MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::XOR), 0,
                    1, MVT::i32, 2, 0, 1, 
              11, 
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VXOR), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              11, 
                OPC_CheckType, MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::XOR8), 0,
                    1, MVT::i64, 2, 0, 1, 
              0, 
            0, 
          75|128,3,  ISD::AND,
            OPC_Scope, 45, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_SwitchType , 9,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ANDC), 0,
                    1, MVT::i32, 2, 0, 1, 
              9,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ANDC8), 0,
                    1, MVT::i64, 2, 0, 1, 
              0, 
            85, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 41,  ISD::XOR,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 9,  MVT::i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ANDC), 0,
                      1, MVT::i32, 2, 1, 0, 
                9,  MVT::i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ANDC8), 0,
                      1, MVT::i64, 2, 1, 0, 
                0, 
              36,  ISD::ROTL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_CheckChild1Type, MVT::i32,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 67,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 3, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 4, 5,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::RLWNM), 0,
                    1, MVT::i32, 4, 0, 1, 4, 6, 
              0, 
            68, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 39, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_SwitchOpcode , 15,  ISD::BUILD_VECTOR,
                  OPC_CheckPredicate, 63,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VANDC), 0,
                      1, MVT::v4i32, 2, 0, 1, 
                15,  ISD::BIT_CONVERT,
                  OPC_CheckPredicate, 64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VANDC), 0,
                      1, MVT::v4i32, 2, 0, 1, 
                0, 
              20, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 63,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VANDC), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            50, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 21, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 63,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VANDC), 0,
                    1, MVT::v4i32, 2, 1, 0, 
              21, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 63,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VANDC), 0,
                    1, MVT::v4i32, 2, 1, 0, 
              0, 
            25, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_CheckPredicate, 64,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VANDC), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            50, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 21, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VANDC), 0,
                    1, MVT::v4i32, 2, 1, 0, 
              21, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 64,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VANDC), 0,
                    1, MVT::v4i32, 2, 1, 0, 
              0, 
            127, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 86, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 19, 
                  OPC_CheckPredicate, 65,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 1, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ANDIo), 0,
                      1, MVT::i32, 2, 0, 3, 
                19, 
                  OPC_CheckPredicate, 66,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 0, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ANDISo), 0,
                      1, MVT::i32, 2, 0, 3, 
                19, 
                  OPC_CheckPredicate, 65,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 1, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ANDIo8), 0,
                      1, MVT::i64, 2, 0, 3, 
                19, 
                  OPC_CheckPredicate, 66,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 0, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ANDISo8), 0,
                      1, MVT::i64, 2, 0, 3, 
                0, 
              11, 
                OPC_CheckType, MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::AND), 0,
                    1, MVT::i32, 2, 0, 1, 
              11, 
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VAND), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              11, 
                OPC_CheckType, MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::AND8), 0,
                    1, MVT::i64, 2, 0, 1, 
              0, 
            0, 
          127|128,1,  ISD::OR,
            OPC_Scope, 45, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_SwitchType , 9,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ORC), 0,
                    1, MVT::i32, 2, 0, 1, 
              9,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ORC8), 0,
                    1, MVT::i64, 2, 0, 1, 
              0, 
            45, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 9,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ORC), 0,
                    1, MVT::i32, 2, 1, 0, 
              9,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ORC8), 0,
                    1, MVT::i64, 2, 1, 0, 
              0, 
            31|128,1, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 118, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 19, 
                  OPC_CheckPredicate, 65,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 1, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ORI), 0,
                      1, MVT::i32, 2, 0, 3, 
                19, 
                  OPC_CheckPredicate, 66,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 0, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ORIS), 0,
                      1, MVT::i32, 2, 0, 3, 
                19, 
                  OPC_CheckPredicate, 65,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 1, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ORI8), 0,
                      1, MVT::i64, 2, 0, 3, 
                19, 
                  OPC_CheckPredicate, 66,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 0, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ORIS8), 0,
                      1, MVT::i64, 2, 0, 3, 
                31, 
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 1, 2,
                  OPC_EmitNode, TARGET_OPCODE(PPC::ORI), 0,
                      1, MVT::i32, 2, 0, 3, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 0, 5,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ORIS), 0,
                      1, MVT::i32, 2, 4, 6, 
                0, 
              11, 
                OPC_CheckType, MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::OR), 0,
                    1, MVT::i32, 2, 0, 1, 
              11, 
                OPC_CheckType, MVT::v4i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VOR), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              11, 
                OPC_CheckType, MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::OR8), 0,
                    1, MVT::i64, 2, 0, 1, 
              0, 
            0, 
          125,  PPCISD::Hi,
            OPC_RecordChild0,
            OPC_MoveChild, 0,
            OPC_SwitchOpcode , 28,  ISD::TargetGlobalAddress,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_SwitchType , 8,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LIS), 0,
                    1, MVT::i32, 1, 0, 
              8,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LIS8), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            28,  ISD::TargetConstantPool,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_SwitchType , 8,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LIS), 0,
                    1, MVT::i32, 1, 0, 
              8,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LIS8), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            28,  ISD::TargetJumpTable,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_SwitchType , 8,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LIS), 0,
                    1, MVT::i32, 1, 0, 
              8,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LIS8), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            28,  ISD::TargetBlockAddress,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_SwitchType , 8,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LIS), 0,
                    1, MVT::i32, 1, 0, 
              8,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LIS8), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            0, 
          125,  PPCISD::Lo,
            OPC_RecordChild0,
            OPC_MoveChild, 0,
            OPC_SwitchOpcode , 28,  ISD::TargetGlobalAddress,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_SwitchType , 8,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LI), 0,
                    1, MVT::i32, 1, 0, 
              8,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LI8), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            28,  ISD::TargetConstantPool,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_SwitchType , 8,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LI), 0,
                    1, MVT::i32, 1, 0, 
              8,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LI8), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            28,  ISD::TargetJumpTable,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_SwitchType , 8,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LI), 0,
                    1, MVT::i32, 1, 0, 
              8,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LI8), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            28,  ISD::TargetBlockAddress,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_SwitchType , 8,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LI), 0,
                    1, MVT::i32, 1, 0, 
              8,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LI8), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            0, 
          25,  ISD::CALLSEQ_END,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::TargetConstant,
            OPC_MoveParent,
            OPC_RecordChild2,
            OPC_MoveChild, 2,
            OPC_CheckOpcode, ISD::TargetConstant,
            OPC_MoveParent,
            OPC_EmitMergeInputChains, 1, 0, 
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADJCALLSTACKUP), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput,
                0, 2, 1, 2, 
          75|128,1,  PPCISD::TC_RETURN,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_RecordChild1,
            OPC_Scope, 24|128,1, 
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 50,  ISD::Constant,
                OPC_SwitchType , 22,  MVT::i32,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::TCRETURNai), 0|OPFL_Chain|OPFL_FlagInput|OPFL_Variadic2,
                      0, 2, 3, 4, 
                22,  MVT::i64,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::TCRETURNai8), 0|OPFL_Chain|OPFL_FlagInput|OPFL_Variadic2,
                      0, 2, 3, 4, 
                0, 
              46,  ISD::TargetGlobalAddress,
                OPC_SwitchType , 20,  MVT::i32,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::TCRETURNdi), 0|OPFL_Chain|OPFL_FlagInput|OPFL_Variadic2,
                      0, 2, 1, 3, 
                20,  MVT::i64,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::TCRETURNdi8), 0|OPFL_Chain|OPFL_FlagInput|OPFL_Variadic2,
                      0, 2, 1, 3, 
                0, 
              46,  ISD::TargetExternalSymbol,
                OPC_SwitchType , 20,  MVT::i32,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::TCRETURNdi), 0|OPFL_Chain|OPFL_FlagInput|OPFL_Variadic2,
                      0, 2, 1, 3, 
                20,  MVT::i64,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::TCRETURNdi8), 0|OPFL_Chain|OPFL_FlagInput|OPFL_Variadic2,
                      0, 2, 1, 3, 
                0, 
              0, 
            21, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitConvertToTarget, 2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::TCRETURNri), 0|OPFL_Chain|OPFL_FlagInput|OPFL_Variadic2,
                  0, 2, 1, 3, 
            21, 
              OPC_CheckChild1Type, MVT::i64,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitConvertToTarget, 2,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::TCRETURNri8), 0|OPFL_Chain|OPFL_FlagInput|OPFL_Variadic2,
                  0, 2, 1, 3, 
            0, 
          55|128,1,  ISD::FNEG,
            OPC_Scope, 27|128,1, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 82,  ISD::FADD,
                OPC_Scope, 39, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::FMUL,
                  OPC_RecordChild0,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_SwitchType , 12,  MVT::f64,
                    OPC_CheckPatternPredicate, 0,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNMADD), 0,
                        1, MVT::f64, 3, 0, 1, 2, 
                  12,  MVT::f32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNMADDS), 0,
                        1, MVT::f32, 3, 0, 1, 2, 
                  0, 
                39, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::FMUL,
                  OPC_RecordChild0,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_SwitchType , 12,  MVT::f64,
                    OPC_CheckPatternPredicate, 0,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNMADD), 0,
                        1, MVT::f64, 3, 1, 2, 0, 
                  12,  MVT::f32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNMADDS), 0,
                        1, MVT::f32, 3, 1, 2, 0, 
                  0, 
                0, 
              39,  ISD::FSUB,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::FMUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_SwitchType , 12,  MVT::f64,
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNMSUB), 0,
                      1, MVT::f64, 3, 0, 1, 2, 
                12,  MVT::f32,
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNMSUBS), 0,
                      1, MVT::f32, 3, 0, 1, 2, 
                0, 
              24,  ISD::FABS,
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_SwitchType , 8,  MVT::f32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNABSS), 0,
                      1, MVT::f32, 1, 0, 
                8,  MVT::f64,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNABSD), 0,
                      1, MVT::f64, 1, 0, 
                0, 
              0, 
            23, 
              OPC_RecordChild0,
              OPC_SwitchType , 8,  MVT::f32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNEGS), 0,
                    1, MVT::f32, 1, 0, 
              8,  MVT::f64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::FNEGD), 0,
                    1, MVT::f64, 1, 0, 
              0, 
            0, 
          116,  ISD::SUB,
            OPC_Scope, 28, 
              OPC_MoveChild, 0,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 8,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::NEG), 0,
                    1, MVT::i32, 1, 0, 
              8,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::NEG8), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            84, 
              OPC_RecordChild0,
              OPC_Scope, 21, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 0,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_EmitConvertToTarget, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBFIC), 0,
                    1, MVT::i32, 2, 1, 2, 
              58, 
                OPC_RecordChild1,
                OPC_SwitchType , 9,  MVT::i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBF), 0,
                      1, MVT::i32, 2, 1, 0, 
                9,  MVT::v16i8,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUBUBM), 0,
                      1, MVT::v16i8, 2, 0, 1, 
                9,  MVT::v8i16,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUBUHM), 0,
                      1, MVT::v8i16, 2, 0, 1, 
                9,  MVT::v4i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSUBUWM), 0,
                      1, MVT::v4i32, 2, 0, 1, 
                9,  MVT::i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBF8), 0,
                      1, MVT::i64, 2, 1, 0, 
                0, 
              0, 
            0, 
          96,  ISD::ADDE,
            OPC_CaptureFlagInput,
            OPC_RecordChild0,
            OPC_Scope, 65, 
              OPC_MoveChild, 1,
              OPC_Scope, 34, 
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_SwitchType , 8,  MVT::i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDME), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 1, 0, 
                8,  MVT::i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDME8), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i64, 1, 0, 
                0, 
              25, 
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_SwitchType , 8,  MVT::i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDZE), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 1, 0, 
                8,  MVT::i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDZE8), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i64, 1, 0, 
                0, 
              0, 
            25, 
              OPC_RecordChild1,
              OPC_SwitchType , 9,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDE), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 2, 0, 1, 
              9,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDE8), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i64, 2, 0, 1, 
              0, 
            0, 
          98,  ISD::SUBE,
            OPC_CaptureFlagInput,
            OPC_Scope, 67, 
              OPC_MoveChild, 0,
              OPC_Scope, 35, 
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 8,  MVT::i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBFME), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 1, 0, 
                8,  MVT::i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBFME8), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i64, 1, 0, 
                0, 
              26, 
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 8,  MVT::i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBFZE), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 1, 0, 
                8,  MVT::i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBFZE8), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i64, 1, 0, 
                0, 
              0, 
            26, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_SwitchType , 9,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBFE), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 2, 1, 0, 
              9,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBFE8), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i64, 2, 1, 0, 
              0, 
            0, 
          84|128,1,  PPCISD::VCMP,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_MoveChild, 2,
            OPC_Scope, 15, 
              OPC_CheckInteger, 70|128,7, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPBFP), 0,
                  1, MVT::v4f32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 70|128,1, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPEQFP), 0,
                  1, MVT::v4f32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 70|128,3, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGEFP), 0,
                  1, MVT::v4f32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 70|128,5, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTFP), 0,
                  1, MVT::v4f32, 2, 0, 1, 
            14, 
              OPC_CheckInteger, 6, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v16i8,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPEQUB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 6|128,6, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v16i8,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTSB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 6|128,4, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v16i8,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTUB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            14, 
              OPC_CheckInteger, 70, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPEQUH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 70|128,6, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTSH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 70|128,4, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTUH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 6|128,1, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPEQUW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 6|128,7, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTSW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 6|128,5, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTUW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            0, 
          84|128,1,  PPCISD::VCMPo,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_MoveChild, 2,
            OPC_Scope, 15, 
              OPC_CheckInteger, 70|128,7, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPBFPo), 0|OPFL_FlagOutput,
                  1, MVT::v4f32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 70|128,1, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPEQFPo), 0|OPFL_FlagOutput,
                  1, MVT::v4f32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 70|128,3, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGEFPo), 0|OPFL_FlagOutput,
                  1, MVT::v4f32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 70|128,5, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTFPo), 0|OPFL_FlagOutput,
                  1, MVT::v4f32, 2, 0, 1, 
            14, 
              OPC_CheckInteger, 6, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v16i8,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPEQUBo), 0|OPFL_FlagOutput,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 6|128,6, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v16i8,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTSBo), 0|OPFL_FlagOutput,
                  1, MVT::v16i8, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 6|128,4, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v16i8,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTUBo), 0|OPFL_FlagOutput,
                  1, MVT::v16i8, 2, 0, 1, 
            14, 
              OPC_CheckInteger, 70, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPEQUHo), 0|OPFL_FlagOutput,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 70|128,6, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTSHo), 0|OPFL_FlagOutput,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 70|128,4, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTUHo), 0|OPFL_FlagOutput,
                  1, MVT::v8i16, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 6|128,1, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPEQUWo), 0|OPFL_FlagOutput,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 6|128,7, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTSWo), 0|OPFL_FlagOutput,
                  1, MVT::v4i32, 2, 0, 1, 
            15, 
              OPC_CheckInteger, 6|128,5, 
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VCMPGTUWo), 0|OPFL_FlagOutput,
                  1, MVT::v4i32, 2, 0, 1, 
            0, 
          64,  ISD::ADDC,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_Scope, 35, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 0,
              OPC_MoveParent,
              OPC_SwitchType , 11,  MVT::i32,
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIC), 0|OPFL_FlagOutput,
                    1, MVT::i32, 2, 0, 2, 
              11,  MVT::i64,
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDIC8), 0|OPFL_FlagOutput,
                    1, MVT::i64, 2, 0, 2, 
              0, 
            11, 
              OPC_CheckType, MVT::i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDC), 0|OPFL_FlagOutput,
                  1, MVT::i32, 2, 0, 1, 
            11, 
              OPC_CheckType, MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADDC8), 0|OPFL_FlagOutput,
                  1, MVT::i64, 2, 0, 1, 
            0, 
          49,  ISD::MUL,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_Scope, 20, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 0,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::MULLI), 0,
                  1, MVT::i32, 2, 0, 2, 
            11, 
              OPC_CheckType, MVT::i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::MULLW), 0,
                  1, MVT::i32, 2, 0, 1, 
            11, 
              OPC_CheckType, MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::MULLD), 0,
                  1, MVT::i64, 2, 0, 1, 
            0, 
          66,  ISD::SUBC,
            OPC_RecordChild0,
            OPC_Scope, 36, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 0,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 11,  MVT::i32,
                OPC_EmitConvertToTarget, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBFIC), 0|OPFL_FlagOutput,
                    1, MVT::i32, 2, 1, 2, 
              11,  MVT::i64,
                OPC_EmitConvertToTarget, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBFIC8), 0|OPFL_FlagOutput,
                    1, MVT::i64, 2, 1, 2, 
              0, 
            25, 
              OPC_RecordChild1,
              OPC_SwitchType , 9,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBFC), 0|OPFL_FlagOutput,
                    1, MVT::i32, 2, 1, 0, 
              9,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SUBFC8), 0|OPFL_FlagOutput,
                    1, MVT::i64, 2, 1, 0, 
              0, 
            0, 
          50|128,2,  ISD::VECTOR_SHUFFLE,
            OPC_Scope, 72, 
              OPC_RecordNode,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::UNDEF,
              OPC_MoveParent,
              OPC_CheckType, MVT::v16i8,
              OPC_Scope, 14, 
                OPC_CheckPredicate, 68,
                OPC_EmitNodeXForm, 5, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSPLTB), 0,
                    1, MVT::v16i8, 2, 2, 1, 
              14, 
                OPC_CheckPredicate, 69,
                OPC_EmitNodeXForm, 6, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSPLTH), 0,
                    1, MVT::v16i8, 2, 2, 1, 
              14, 
                OPC_CheckPredicate, 70,
                OPC_EmitNodeXForm, 7, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSPLTW), 0,
                    1, MVT::v16i8, 2, 2, 1, 
              15, 
                OPC_CheckPredicate, 71,
                OPC_EmitNodeXForm, 8, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSLDOI), 0,
                    1, MVT::v16i8, 3, 1, 1, 2, 
              0, 
            106, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::UNDEF,
              OPC_MoveParent,
              OPC_CheckType, MVT::v16i8,
              OPC_Scope, 11, 
                OPC_CheckPredicate, 72,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPKUWUM), 0,
                    1, MVT::v16i8, 2, 0, 0, 
              11, 
                OPC_CheckPredicate, 73,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPKUHUM), 0,
                    1, MVT::v16i8, 2, 0, 0, 
              11, 
                OPC_CheckPredicate, 74,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGLB), 0,
                    1, MVT::v16i8, 2, 0, 0, 
              11, 
                OPC_CheckPredicate, 75,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGLH), 0,
                    1, MVT::v16i8, 2, 0, 0, 
              11, 
                OPC_CheckPredicate, 76,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGLW), 0,
                    1, MVT::v16i8, 2, 0, 0, 
              11, 
                OPC_CheckPredicate, 77,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGHB), 0,
                    1, MVT::v16i8, 2, 0, 0, 
              11, 
                OPC_CheckPredicate, 78,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGHH), 0,
                    1, MVT::v16i8, 2, 0, 0, 
              11, 
                OPC_CheckPredicate, 79,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGHW), 0,
                    1, MVT::v16i8, 2, 0, 0, 
              0, 
            20, 
              OPC_RecordNode,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_CheckPredicate, 80,
              OPC_CheckType, MVT::v16i8,
              OPC_EmitNodeXForm, 9, 0,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSLDOI), 0,
                  1, MVT::v16i8, 3, 1, 2, 3, 
            102, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_CheckType, MVT::v16i8,
              OPC_Scope, 11, 
                OPC_CheckPredicate, 81,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGHB), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              11, 
                OPC_CheckPredicate, 82,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGHH), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              11, 
                OPC_CheckPredicate, 83,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGHW), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              11, 
                OPC_CheckPredicate, 84,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGLB), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              11, 
                OPC_CheckPredicate, 85,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGLH), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              11, 
                OPC_CheckPredicate, 86,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMRGLW), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              11, 
                OPC_CheckPredicate, 87,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPKUHUM), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              11, 
                OPC_CheckPredicate, 88,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPKUWUM), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            0, 
          17,  ISD::CALLSEQ_START,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::TargetConstant,
            OPC_MoveParent,
            OPC_EmitMergeInputChains, 1, 0, 
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::ADJCALLSTACKDOWN), 0|OPFL_Chain|OPFL_FlagOutput,
                0, 1, 1, 
          101,  PPCISD::CALL_Darwin,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_SwitchOpcode , 32,  ISD::Constant,
              OPC_SwitchType , 13,  MVT::i32,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BLA_Darwin), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 2, 
              13,  MVT::i64,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BLA8_Darwin), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 2, 
              0, 
            28,  ISD::TargetGlobalAddress,
              OPC_SwitchType , 11,  MVT::i32,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BL_Darwin), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              11,  MVT::i64,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BL8_Darwin), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              0, 
            28,  ISD::TargetExternalSymbol,
              OPC_SwitchType , 11,  MVT::i32,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BL_Darwin), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              11,  MVT::i64,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BL8_Darwin), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              0, 
            0, 
          101,  PPCISD::CALL_SVR4,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_SwitchOpcode , 32,  ISD::Constant,
              OPC_SwitchType , 13,  MVT::i32,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BLA_SVR4), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 2, 
              13,  MVT::i64,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BLA8_ELF), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 2, 
              0, 
            28,  ISD::TargetGlobalAddress,
              OPC_SwitchType , 11,  MVT::i32,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BL_SVR4), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              11,  MVT::i64,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BL8_ELF), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              0, 
            28,  ISD::TargetExternalSymbol,
              OPC_SwitchType , 11,  MVT::i32,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BL_SVR4), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              11,  MVT::i64,
                OPC_MoveParent,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::BL8_ELF), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              0, 
            0, 
          109,  ISD::SRA,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_Scope, 35, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_SwitchType , 11,  MVT::i32,
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SRAWI), 0,
                    1, MVT::i32, 2, 0, 2, 
              11,  MVT::i64,
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SRADI), 0,
                    1, MVT::i64, 2, 0, 2, 
              0, 
            26, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_SwitchType , 9,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SRAW), 0,
                    1, MVT::i32, 2, 0, 1, 
              9,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SRAD), 0,
                    1, MVT::i64, 2, 0, 1, 
              0, 
            13, 
              OPC_CheckChild1Type, MVT::v16i8,
              OPC_CheckType, MVT::v16i8,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRAB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            13, 
              OPC_CheckChild1Type, MVT::v8i16,
              OPC_CheckType, MVT::v8i16,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRAH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            13, 
              OPC_CheckChild1Type, MVT::v4i32,
              OPC_CheckType, MVT::v4i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRAW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            0, 
          18,  PPCISD::MTFSB0,
            OPC_CaptureFlagInput,
            OPC_RecordChild0,
            OPC_MoveChild, 0,
            OPC_CheckOpcode, ISD::Constant,
            OPC_CheckType, MVT::i32,
            OPC_MoveParent,
            OPC_EmitConvertToTarget, 0,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::MTFSB0), 0|OPFL_FlagInput|OPFL_FlagOutput,
                0, 1, 1, 
          18,  PPCISD::MTFSB1,
            OPC_CaptureFlagInput,
            OPC_RecordChild0,
            OPC_MoveChild, 0,
            OPC_CheckOpcode, ISD::Constant,
            OPC_CheckType, MVT::i32,
            OPC_MoveParent,
            OPC_EmitConvertToTarget, 0,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::MTFSB1), 0|OPFL_FlagInput|OPFL_FlagOutput,
                0, 1, 1, 
          23,  PPCISD::MTFSF,
            OPC_CaptureFlagInput,
            OPC_RecordChild0,
            OPC_MoveChild, 0,
            OPC_CheckOpcode, ISD::Constant,
            OPC_CheckType, MVT::i32,
            OPC_MoveParent,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_EmitConvertToTarget, 0,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::MTFSF), 0|OPFL_FlagInput,
                1, MVT::f64, 3, 3, 1, 2, 
          20|128,1,  ISD::FADD,
            OPC_Scope, 52, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 12,  MVT::f64,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::FMADD), 0,
                    1, MVT::f64, 3, 0, 1, 2, 
              12,  MVT::f32,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::FMADDS), 0,
                    1, MVT::f32, 3, 0, 1, 2, 
              12,  MVT::v4f32,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMADDFP), 0,
                    1, MVT::v4f32, 3, 0, 1, 2, 
              0, 
            92, 
              OPC_RecordChild0,
              OPC_Scope, 51, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::FMUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_SwitchType , 12,  MVT::f64,
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FMADD), 0,
                      1, MVT::f64, 3, 1, 2, 0, 
                12,  MVT::f32,
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FMADDS), 0,
                      1, MVT::f32, 3, 1, 2, 0, 
                12,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMADDFP), 0,
                      1, MVT::v4f32, 3, 1, 2, 0, 
                0, 
              36, 
                OPC_RecordChild1,
                OPC_SwitchType , 9,  MVT::f64,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FADD), 0,
                      1, MVT::f64, 2, 0, 1, 
                9,  MVT::f32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::FADDS), 0,
                      1, MVT::f32, 2, 0, 1, 
                9,  MVT::v4f32,
                  OPC_MorphNodeTo, TARGET_OPCODE(PPC::VADDFP), 0,
                      1, MVT::v4f32, 2, 0, 1, 
                0, 
              0, 
            0, 
          125,  ISD::SHL,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_Scope, 51, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_SwitchType , 21,  MVT::i32,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 10, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::RLWINM), 0,
                    1, MVT::i32, 4, 0, 2, 3, 5, 
              17,  MVT::i64,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 11, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::RLDICR), 0,
                    1, MVT::i64, 3, 0, 2, 4, 
              0, 
            26, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_SwitchType , 9,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SLW), 0,
                    1, MVT::i32, 2, 0, 1, 
              9,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SLD), 0,
                    1, MVT::i64, 2, 0, 1, 
              0, 
            13, 
              OPC_CheckChild1Type, MVT::v16i8,
              OPC_CheckType, MVT::v16i8,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSLB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            13, 
              OPC_CheckChild1Type, MVT::v8i16,
              OPC_CheckType, MVT::v8i16,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSLH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            13, 
              OPC_CheckChild1Type, MVT::v4i32,
              OPC_CheckType, MVT::v4i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSLW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            0, 
          125,  ISD::SRL,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_Scope, 51, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_SwitchType , 21,  MVT::i32,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 12, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 31, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::RLWINM), 0,
                    1, MVT::i32, 4, 0, 3, 4, 5, 
              17,  MVT::i64,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 13, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::RLDICL), 0,
                    1, MVT::i64, 3, 0, 3, 4, 
              0, 
            26, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_SwitchType , 9,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SRW), 0,
                    1, MVT::i32, 2, 0, 1, 
              9,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::SRD), 0,
                    1, MVT::i64, 2, 0, 1, 
              0, 
            13, 
              OPC_CheckChild1Type, MVT::v16i8,
              OPC_CheckType, MVT::v16i8,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRB), 0,
                  1, MVT::v16i8, 2, 0, 1, 
            13, 
              OPC_CheckChild1Type, MVT::v8i16,
              OPC_CheckType, MVT::v8i16,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRH), 0,
                  1, MVT::v8i16, 2, 0, 1, 
            13, 
              OPC_CheckChild1Type, MVT::v4i32,
              OPC_CheckType, MVT::v4i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSRW), 0,
                  1, MVT::v4i32, 2, 0, 1, 
            0, 
          91,  ISD::ROTL,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_Scope, 47, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_SwitchType , 19,  MVT::i32,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_EmitInteger, MVT::i32, 31, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::RLWINM), 0,
                    1, MVT::i32, 4, 0, 2, 3, 4, 
              15,  MVT::i64,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::RLDICL), 0,
                    1, MVT::i64, 3, 0, 2, 3, 
              0, 
            38, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_SwitchType , 17,  MVT::i32,
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_EmitInteger, MVT::i32, 31, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::RLWNM), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              13,  MVT::i64,
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::RLDCL), 0,
                    1, MVT::i64, 3, 0, 1, 2, 
              0, 
            0, 
          18,  PPCISD::TOC_ENTRY,
            OPC_RecordChild0,
            OPC_MoveChild, 0,
            OPC_CheckOpcode, ISD::TargetGlobalAddress,
            OPC_MoveParent,
            OPC_RecordChild1,
            OPC_CheckType, MVT::i64,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::LDtoc), 0,
                1, MVT::i64, 2, 0, 1, 
          97,  ISD::Constant,
            OPC_RecordNode,
            OPC_SwitchType , 59,  MVT::i32,
              OPC_Scope, 12, 
                OPC_CheckPredicate, 0,
                OPC_EmitConvertToTarget, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LI), 0,
                    1, MVT::i32, 1, 1, 
              15, 
                OPC_CheckPredicate, 1,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitNodeXForm, 0, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LIS), 0,
                    1, MVT::i32, 1, 2, 
              27, 
                OPC_EmitConvertToTarget, 0,
                OPC_EmitNodeXForm, 0, 1,
                OPC_EmitNode, TARGET_OPCODE(PPC::LIS), 0,
                    1, MVT::i32, 1, 2, 
                OPC_EmitConvertToTarget, 0,
                OPC_EmitNodeXForm, 1, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::ORI), 0,
                    1, MVT::i32, 2, 3, 5, 
              0, 
            31,  MVT::i64,
              OPC_Scope, 12, 
                OPC_CheckPredicate, 0,
                OPC_EmitConvertToTarget, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LI8), 0,
                    1, MVT::i64, 1, 1, 
              15, 
                OPC_CheckPredicate, 1,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitNodeXForm, 0, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::LIS8), 0,
                    1, MVT::i64, 1, 2, 
              0, 
            0, 
          63,  ISD::BUILD_VECTOR,
            OPC_Scope, 48, 
              OPC_RecordNode,
              OPC_SwitchType , 13,  MVT::v16i8,
                OPC_CheckPredicate, 89,
                OPC_EmitNodeXForm, 14, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSPLTISB), 0,
                    1, MVT::v16i8, 1, 1, 
              13,  MVT::v8i16,
                OPC_CheckPredicate, 90,
                OPC_EmitNodeXForm, 15, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSPLTISH), 0,
                    1, MVT::v8i16, 1, 1, 
              13,  MVT::v4i32,
                OPC_CheckPredicate, 91,
                OPC_EmitNodeXForm, 16, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::VSPLTISW), 0,
                    1, MVT::v4i32, 1, 1, 
              0, 
            11, 
              OPC_CheckPredicate, 92,
              OPC_CheckType, MVT::v4i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::V_SET0), 0,
                  1, MVT::v4i32, 0, 
            0, 
          83,  ISD::BIT_CONVERT,
            OPC_RecordChild0,
            OPC_Scope, 19, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_SwitchType , 3,  MVT::v16i8,
                OPC_CompleteMatch, 1, 0, 

              3,  MVT::v4i32,
                OPC_CompleteMatch, 1, 0, 

              3,  MVT::v4f32,
                OPC_CompleteMatch, 1, 0, 

              0, 
            19, 
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_SwitchType , 3,  MVT::v16i8,
                OPC_CompleteMatch, 1, 0, 

              3,  MVT::v8i16,
                OPC_CompleteMatch, 1, 0, 

              3,  MVT::v4f32,
                OPC_CompleteMatch, 1, 0, 

              0, 
            19, 
              OPC_CheckChild0Type, MVT::v4f32,
              OPC_SwitchType , 3,  MVT::v16i8,
                OPC_CompleteMatch, 1, 0, 

              3,  MVT::v8i16,
                OPC_CompleteMatch, 1, 0, 

              3,  MVT::v4i32,
                OPC_CompleteMatch, 1, 0, 

              0, 
            19, 
              OPC_CheckChild0Type, MVT::v16i8,
              OPC_SwitchType , 3,  MVT::v8i16,
                OPC_CompleteMatch, 1, 0, 

              3,  MVT::v4i32,
                OPC_CompleteMatch, 1, 0, 

              3,  MVT::v4f32,
                OPC_CompleteMatch, 1, 0, 

              0, 
            0, 
          19,  PPCISD::RET_FLAG,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_EmitMergeInputChains, 1, 0, 
            OPC_EmitInteger, MVT::i32, 20, 
            OPC_EmitRegister, MVT::i32, 0 ,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::BLR), 0|OPFL_Chain|OPFL_FlagInput,
                0, 2, 1, 2, 
          17,  ISD::BR,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::BasicBlock,
            OPC_MoveParent,
            OPC_EmitMergeInputChains, 1, 0, 
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::B), 0|OPFL_Chain,
                0, 1, 1, 
          28,  PPCISD::BCTRL_Darwin,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_Scope, 11, 
              OPC_CheckPatternPredicate, 1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::BCTRL_Darwin), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic0,
                  0, 0, 
            11, 
              OPC_CheckPatternPredicate, 2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::BCTRL8_Darwin), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic0,
                  0, 0, 
            0, 
          28,  PPCISD::BCTRL_SVR4,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_Scope, 11, 
              OPC_CheckPatternPredicate, 1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::BCTRL_SVR4), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic0,
                  0, 0, 
            11, 
              OPC_CheckPatternPredicate, 2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::BCTRL8_ELF), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic0,
                  0, 0, 
            0, 
          10,  ISD::TRAP,
            OPC_RecordNode,
            OPC_EmitMergeInputChains, 1, 0, 
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::TRAP), 0|OPFL_Chain,
                0, 0, 
          28,  PPCISD::SHL,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_CheckChild1Type, MVT::i32,
            OPC_SwitchType , 9,  MVT::i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::SLW), 0,
                  1, MVT::i32, 2, 0, 1, 
            9,  MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::SLD), 0,
                  1, MVT::i64, 2, 0, 1, 
            0, 
          28,  PPCISD::SRL,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_CheckChild1Type, MVT::i32,
            OPC_SwitchType , 9,  MVT::i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::SRW), 0,
                  1, MVT::i32, 2, 0, 1, 
            9,  MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::SRD), 0,
                  1, MVT::i64, 2, 0, 1, 
            0, 
          28,  PPCISD::SRA,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_CheckChild1Type, MVT::i32,
            OPC_SwitchType , 9,  MVT::i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::SRAW), 0,
                  1, MVT::i32, 2, 0, 1, 
            9,  MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::SRAD), 0,
                  1, MVT::i64, 2, 0, 1, 
            0, 
          23,  ISD::CTLZ,
            OPC_RecordChild0,
            OPC_SwitchType , 8,  MVT::i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::CNTLZW), 0,
                  1, MVT::i32, 1, 0, 
            8,  MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::CNTLZD), 0,
                  1, MVT::i64, 1, 0, 
            0, 
          71,  ISD::SIGN_EXTEND_INREG,
            OPC_RecordChild0,
            OPC_MoveChild, 1,
            OPC_Scope, 25, 
              OPC_CheckValueType, MVT::i8,
              OPC_MoveParent,
              OPC_SwitchType , 8,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::EXTSB), 0,
                    1, MVT::i32, 1, 0, 
              8,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::EXTSB8), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            25, 
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_SwitchType , 8,  MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::EXTSH), 0,
                    1, MVT::i32, 1, 0, 
              8,  MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(PPC::EXTSH8), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            13, 
              OPC_CheckValueType, MVT::i32,
              OPC_MoveParent,
              OPC_CheckType, MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::EXTSW), 0,
                  1, MVT::i64, 1, 0, 
            0, 
          11,  PPCISD::FCTIWZ,
            OPC_RecordChild0,
            OPC_CheckType, MVT::f64,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::FCTIWZ), 0,
                1, MVT::f64, 1, 0, 
          13,  ISD::FP_ROUND,
            OPC_RecordChild0,
            OPC_CheckChild0Type, MVT::f64,
            OPC_CheckType, MVT::f32,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::FRSP), 0,
                1, MVT::f32, 1, 0, 
          23,  ISD::FSQRT,
            OPC_RecordChild0,
            OPC_SwitchType , 8,  MVT::f64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::FSQRT), 0,
                  1, MVT::f64, 1, 0, 
            8,  MVT::f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::FSQRTS), 0,
                  1, MVT::f32, 1, 0, 
            0, 
          13,  ISD::FP_EXTEND,
            OPC_RecordChild0,
            OPC_CheckChild0Type, MVT::f32,
            OPC_CheckType, MVT::f64,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::FMRSD), 0,
                1, MVT::f64, 1, 0, 
          23,  ISD::FABS,
            OPC_RecordChild0,
            OPC_SwitchType , 8,  MVT::f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::FABSS), 0,
                  1, MVT::f32, 1, 0, 
            8,  MVT::f64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::FABSD), 0,
                  1, MVT::f64, 1, 0, 
            0, 
          31,  PPCISD::MTCTR,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_RecordChild1,
            OPC_Scope, 12, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::MTCTR), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput,
                  0, 1, 1, 
            12, 
              OPC_CheckChild1Type, MVT::i64,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::MTCTR8), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput,
                  0, 1, 1, 
            0, 
          7,  PPCISD::MFFS,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::MFFS), 0|OPFL_FlagOutput,
                1, MVT::f64, 0, 
          14,  PPCISD::FADDRTZ,
            OPC_CaptureFlagInput,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_CheckType, MVT::f64,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::FADDrtz), 0|OPFL_FlagInput|OPFL_FlagOutput,
                1, MVT::f64, 2, 0, 1, 
          26,  ISD::SDIV,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_SwitchType , 9,  MVT::i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DIVW), 0,
                  1, MVT::i32, 2, 0, 1, 
            9,  MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DIVD), 0,
                  1, MVT::i64, 2, 0, 1, 
            0, 
          26,  ISD::UDIV,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_SwitchType , 9,  MVT::i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DIVWU), 0,
                  1, MVT::i32, 2, 0, 1, 
            9,  MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::DIVDU), 0,
                  1, MVT::i64, 2, 0, 1, 
            0, 
          26,  ISD::MULHS,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_SwitchType , 9,  MVT::i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::MULHW), 0,
                  1, MVT::i32, 2, 0, 1, 
            9,  MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::MULHD), 0,
                  1, MVT::i64, 2, 0, 1, 
            0, 
          26,  ISD::MULHU,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_SwitchType , 9,  MVT::i32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::MULHWU), 0,
                  1, MVT::i32, 2, 0, 1, 
            9,  MVT::i64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::MULHDU), 0,
                  1, MVT::i64, 2, 0, 1, 
            0, 
          29,  PPCISD::FSEL,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_SwitchType , 10,  MVT::f64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::FSELD), 0,
                  1, MVT::f64, 3, 0, 1, 2, 
            10,  MVT::f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::FSELS), 0,
                  1, MVT::f32, 3, 0, 1, 2, 
            0, 
          26,  ISD::FDIV,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_SwitchType , 9,  MVT::f64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::FDIV), 0,
                  1, MVT::f64, 2, 0, 1, 
            9,  MVT::f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::FDIVS), 0,
                  1, MVT::f32, 2, 0, 1, 
            0, 
          45,  ISD::FMUL,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_SwitchType , 9,  MVT::f64,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::FMUL), 0,
                  1, MVT::f64, 2, 0, 1, 
            9,  MVT::f32,
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::FMULS), 0,
                  1, MVT::f32, 2, 0, 1, 
            17,  MVT::v4f32,
              OPC_EmitNode, TARGET_OPCODE(PPC::V_SET0), 0,
                  1, MVT::v4i32, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMADDFP), 0,
                  1, MVT::v4f32, 3, 0, 1, 2, 
            0, 
          15,  PPCISD::VMADDFP,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_CheckType, MVT::v4f32,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::VMADDFP), 0,
                1, MVT::v4f32, 3, 0, 1, 2, 
          15,  PPCISD::VNMSUBFP,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_CheckType, MVT::v4f32,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::VNMSUBFP), 0,
                1, MVT::v4f32, 3, 0, 1, 2, 
          15,  PPCISD::VPERM,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_CheckType, MVT::v16i8,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::VPERM), 0,
                1, MVT::v16i8, 3, 0, 1, 2, 
          7,  PPCISD::NOP,
            OPC_CaptureFlagInput,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::NOP), 0|OPFL_FlagInput|OPFL_FlagOutput,
                0, 0, 
          11,  PPCISD::EXTSW_32,
            OPC_RecordChild0,
            OPC_CheckType, MVT::i32,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::EXTSW_32), 0,
                1, MVT::i32, 1, 0, 
          13,  ISD::SIGN_EXTEND,
            OPC_RecordChild0,
            OPC_CheckChild0Type, MVT::i32,
            OPC_CheckType, MVT::i64,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::EXTSW_32_64), 0,
                1, MVT::i64, 1, 0, 
          15,  PPCISD::LOAD_TOC,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_RecordChild1,
            OPC_CheckChild1Type, MVT::i64,
            OPC_EmitMergeInputChains, 1, 0, 
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::LDinto_toc), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput,
                0, 1, 1, 
          11,  PPCISD::TOC_RESTORE,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_EmitMergeInputChains, 1, 0, 
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::LDtoc_restore), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput,
                0, 0, 
          11,  PPCISD::FCFID,
            OPC_RecordChild0,
            OPC_CheckType, MVT::f64,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::FCFID), 0,
                1, MVT::f64, 1, 0, 
          11,  PPCISD::FCTIDZ,
            OPC_RecordChild0,
            OPC_CheckType, MVT::f64,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::FCTIDZ), 0,
                1, MVT::f64, 1, 0, 
          14,  ISD::ANY_EXTEND,
            OPC_RecordChild0,
            OPC_CheckChild0Type, MVT::i32,
            OPC_CheckType, MVT::i64,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::OR4To8), 0,
                1, MVT::i64, 2, 0, 0, 
          14,  ISD::TRUNCATE,
            OPC_RecordChild0,
            OPC_CheckChild0Type, MVT::i64,
            OPC_CheckType, MVT::i32,
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::OR8To4), 0,
                1, MVT::i32, 2, 0, 0, 
          30,  ISD::ZERO_EXTEND,
            OPC_RecordChild0,
            OPC_CheckChild0Type, MVT::i32,
            OPC_CheckType, MVT::i64,
            OPC_EmitNode, TARGET_OPCODE(PPC::OR4To8), 0,
                1, MVT::i64, 2, 0, 0, 
            OPC_EmitInteger, MVT::i32, 0, 
            OPC_EmitInteger, MVT::i32, 32, 
            OPC_MorphNodeTo, TARGET_OPCODE(PPC::RLDICL), 0,
                1, MVT::i64, 3, 1, 2, 3, 
          0, 
    0
  }; // Total Array size is 11066 bytes

  #undef TARGET_OPCODE
  return SelectCodeCommon(N, MatcherTable,sizeof(MatcherTable));
}

bool CheckPatternPredicate(unsigned PredNo) const {
  switch (PredNo) {
  default: assert(0 && "Invalid predicate in table?");
  case 0: return (!NoExcessFPPrecision);
  case 1: return (!PPCSubTarget.isPPC64());
  case 2: return (PPCSubTarget.isPPC64());
  }
}

bool CheckNodePredicate(SDNode *Node, unsigned PredNo) const {
  switch (PredNo) {
  default: assert(0 && "Invalid predicate in table?");
  case 0: { // Predicate_immSExt16
    ConstantSDNode*N = cast<ConstantSDNode>(Node);

  // immSExt16 predicate - True if the immediate fits in a 16-bit sign extended
  // field.  Used by instructions like 'addi'.
  if (N->getValueType(0) == MVT::i32)
    return (int32_t)N->getZExtValue() == (short)N->getZExtValue();
  else
    return (int64_t)N->getZExtValue() == (short)N->getZExtValue();

  }
  case 1: { // Predicate_imm16ShiftedSExt
    ConstantSDNode*N = cast<ConstantSDNode>(Node);

  // imm16ShiftedSExt predicate - True if only bits in the top 16-bits of the
  // immediate are set.  Used by instructions like 'addis'.  Identical to 
  // imm16ShiftedZExt in 32-bit mode.
  if (N->getZExtValue() & 0xFFFF) return false;
  if (N->getValueType(0) == MVT::i32)
    return true;
  // For 64-bit, make sure it is sext right.
  return N->getZExtValue() == (uint64_t)(int)N->getZExtValue();

  }
  case 2: { // Predicate_unindexedload
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getAddressingMode() == ISD::UNINDEXED;

  }
  case 3: { // Predicate_zextload
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::ZEXTLOAD;

  }
  case 4: { // Predicate_zextloadi8
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i8;

  }
  case 5: { // Predicate_sextload
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::SEXTLOAD;

  }
  case 6: { // Predicate_sextloadi16
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

  }
  case 7: { // Predicate_zextloadi16
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

  }
  case 8: { // Predicate_load
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::NON_EXTLOAD;

  }
  case 9: { // Predicate_zextloadi1
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i1;

  }
  case 10: { // Predicate_extload
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::EXTLOAD;

  }
  case 11: { // Predicate_extloadi1
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i1;

  }
  case 12: { // Predicate_extloadi8
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i8;

  }
  case 13: { // Predicate_extloadi16
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

  }
  case 14: { // Predicate_sextloadi32
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

  }
  case 15: { // Predicate_zextloadi32
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

  }
  case 16: { // Predicate_extloadi32
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

  }
  case 17: { // Predicate_extloadf32
    SDNode *N = Node;

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::f32;

  }
  case 18: { // Predicate_unindexedstore
    SDNode *N = Node;

  return cast<StoreSDNode>(N)->getAddressingMode() == ISD::UNINDEXED;

  }
  case 19: { // Predicate_truncstore
    SDNode *N = Node;

  return cast<StoreSDNode>(N)->isTruncatingStore();

  }
  case 20: { // Predicate_truncstorei8
    SDNode *N = Node;

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i8;

  }
  case 21: { // Predicate_truncstorei16
    SDNode *N = Node;

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i16;

  }
  case 22: { // Predicate_store
    SDNode *N = Node;

  return !cast<StoreSDNode>(N)->isTruncatingStore();

  }
  case 23: { // Predicate_itruncstore
    SDNode *N = Node;

  return cast<StoreSDNode>(N)->isTruncatingStore();

  }
  case 24: { // Predicate_pre_truncst
    SDNode *N = Node;

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::PRE_INC || AM == ISD::PRE_DEC;

  }
  case 25: { // Predicate_pre_truncsti8
    SDNode *N = Node;

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i8;

  }
  case 26: { // Predicate_pre_truncsti16
    SDNode *N = Node;

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i16;

  }
  case 27: { // Predicate_istore
    SDNode *N = Node;

  return !cast<StoreSDNode>(N)->isTruncatingStore();

  }
  case 28: { // Predicate_pre_store
    SDNode *N = Node;

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::PRE_INC || AM == ISD::PRE_DEC;

  }
  case 29: { // Predicate_truncstorei32
    SDNode *N = Node;

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i32;

  }
  case 30: { // Predicate_V_immneg0
    SDNode *N = Node;

  return PPC::isAllNegativeZeroVector(N);

  }
  case 31: { // Predicate_atomic_load_add_8
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
  }
  case 32: { // Predicate_atomic_load_add_16
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
  }
  case 33: { // Predicate_atomic_load_add_32
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
  }
  case 34: { // Predicate_atomic_load_add_64
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
  }
  case 35: { // Predicate_atomic_load_sub_8
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
  }
  case 36: { // Predicate_atomic_load_sub_16
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
  }
  case 37: { // Predicate_atomic_load_sub_32
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
  }
  case 38: { // Predicate_atomic_load_sub_64
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
  }
  case 39: { // Predicate_atomic_load_and_8
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
  }
  case 40: { // Predicate_atomic_load_and_16
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
  }
  case 41: { // Predicate_atomic_load_and_32
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
  }
  case 42: { // Predicate_atomic_load_and_64
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
  }
  case 43: { // Predicate_atomic_load_or_8
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
  }
  case 44: { // Predicate_atomic_load_or_16
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
  }
  case 45: { // Predicate_atomic_load_or_32
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
  }
  case 46: { // Predicate_atomic_load_or_64
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
  }
  case 47: { // Predicate_atomic_load_xor_8
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
  }
  case 48: { // Predicate_atomic_load_xor_16
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
  }
  case 49: { // Predicate_atomic_load_xor_32
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
  }
  case 50: { // Predicate_atomic_load_xor_64
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
  }
  case 51: { // Predicate_atomic_load_nand_8
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
  }
  case 52: { // Predicate_atomic_load_nand_16
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
  }
  case 53: { // Predicate_atomic_load_nand_32
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
  }
  case 54: { // Predicate_atomic_load_nand_64
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
  }
  case 55: { // Predicate_atomic_cmp_swap_8
    SDNode *N = Node;

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;

  }
  case 56: { // Predicate_atomic_cmp_swap_16
    SDNode *N = Node;

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;

  }
  case 57: { // Predicate_atomic_cmp_swap_32
    SDNode *N = Node;

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;

  }
  case 58: { // Predicate_atomic_cmp_swap_64
    SDNode *N = Node;

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;

  }
  case 59: { // Predicate_atomic_swap_8
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
  }
  case 60: { // Predicate_atomic_swap_16
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
  }
  case 61: { // Predicate_atomic_swap_32
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
  }
  case 62: { // Predicate_atomic_swap_64
    SDNode *N = Node;

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
  }
  case 63: { // Predicate_immAllOnesV
    SDNode *N = Node;

  return ISD::isBuildVectorAllOnes(N);

  }
  case 64: { // Predicate_immAllOnesV_bc
    SDNode *N = Node;

  return ISD::isBuildVectorAllOnes(N);

  }
  case 65: { // Predicate_immZExt16
    ConstantSDNode*N = cast<ConstantSDNode>(Node);

  // immZExt16 predicate - True if the immediate fits in a 16-bit zero extended
  // field.  Used by instructions like 'ori'.
  return (uint64_t)N->getZExtValue() == (unsigned short)N->getZExtValue();

  }
  case 66: { // Predicate_imm16ShiftedZExt
    ConstantSDNode*N = cast<ConstantSDNode>(Node);

  // imm16ShiftedZExt predicate - True if only bits in the top 16-bits of the
  // immediate are set.  Used by instructions like 'xoris'.
  return (N->getZExtValue() & ~uint64_t(0xFFFF0000)) == 0;

  }
  case 67: { // Predicate_maskimm32
    ConstantSDNode*N = cast<ConstantSDNode>(Node);

  // maskImm predicate - True if immediate is a run of ones.
  unsigned mb, me;
  if (N->getValueType(0) == MVT::i32)
    return isRunOfOnes((unsigned)N->getZExtValue(), mb, me);
  else
    return false;

  }
  case 68: { // Predicate_vspltb_shuffle
    SDNode *N = Node;

  return PPC::isSplatShuffleMask(cast<ShuffleVectorSDNode>(N), 1);

  }
  case 69: { // Predicate_vsplth_shuffle
    SDNode *N = Node;

  return PPC::isSplatShuffleMask(cast<ShuffleVectorSDNode>(N), 2);

  }
  case 70: { // Predicate_vspltw_shuffle
    SDNode *N = Node;

  return PPC::isSplatShuffleMask(cast<ShuffleVectorSDNode>(N), 4);

  }
  case 71: { // Predicate_vsldoi_unary_shuffle
    SDNode *N = Node;

  return PPC::isVSLDOIShuffleMask(N, true) != -1;

  }
  case 72: { // Predicate_vpkuwum_unary_shuffle
    SDNode *N = Node;

  return PPC::isVPKUWUMShuffleMask(cast<ShuffleVectorSDNode>(N), true);

  }
  case 73: { // Predicate_vpkuhum_unary_shuffle
    SDNode *N = Node;

  return PPC::isVPKUHUMShuffleMask(cast<ShuffleVectorSDNode>(N), true);

  }
  case 74: { // Predicate_vmrglb_unary_shuffle
    SDNode *N = Node;

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 1, true);

  }
  case 75: { // Predicate_vmrglh_unary_shuffle
    SDNode *N = Node;

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 2, true);

  }
  case 76: { // Predicate_vmrglw_unary_shuffle
    SDNode *N = Node;

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 4, true);

  }
  case 77: { // Predicate_vmrghb_unary_shuffle
    SDNode *N = Node;

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 1, true);

  }
  case 78: { // Predicate_vmrghh_unary_shuffle
    SDNode *N = Node;

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 2, true);

  }
  case 79: { // Predicate_vmrghw_unary_shuffle
    SDNode *N = Node;

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 4, true);

  }
  case 80: { // Predicate_vsldoi_shuffle
    SDNode *N = Node;

  return PPC::isVSLDOIShuffleMask(N, false) != -1;

  }
  case 81: { // Predicate_vmrghb_shuffle
    SDNode *N = Node;

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 1, false);

  }
  case 82: { // Predicate_vmrghh_shuffle
    SDNode *N = Node;

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 2, false);

  }
  case 83: { // Predicate_vmrghw_shuffle
    SDNode *N = Node;

  return PPC::isVMRGHShuffleMask(cast<ShuffleVectorSDNode>(N), 4, false);

  }
  case 84: { // Predicate_vmrglb_shuffle
    SDNode *N = Node;

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 1, false);

  }
  case 85: { // Predicate_vmrglh_shuffle
    SDNode *N = Node;

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 2, false);

  }
  case 86: { // Predicate_vmrglw_shuffle
    SDNode *N = Node;

  return PPC::isVMRGLShuffleMask(cast<ShuffleVectorSDNode>(N), 4, false);

  }
  case 87: { // Predicate_vpkuhum_shuffle
    SDNode *N = Node;

  return PPC::isVPKUHUMShuffleMask(cast<ShuffleVectorSDNode>(N), false);

  }
  case 88: { // Predicate_vpkuwum_shuffle
    SDNode *N = Node;

  return PPC::isVPKUWUMShuffleMask(cast<ShuffleVectorSDNode>(N), false);

  }
  case 89: { // Predicate_vecspltisb
    SDNode *N = Node;

  return PPC::get_VSPLTI_elt(N, 1, *CurDAG).getNode() != 0;

  }
  case 90: { // Predicate_vecspltish
    SDNode *N = Node;

  return PPC::get_VSPLTI_elt(N, 2, *CurDAG).getNode() != 0;

  }
  case 91: { // Predicate_vecspltisw
    SDNode *N = Node;

  return PPC::get_VSPLTI_elt(N, 4, *CurDAG).getNode() != 0;

  }
  case 92: { // Predicate_immAllZerosV
    SDNode *N = Node;

  return ISD::isBuildVectorAllZeros(N);

  }
  }
}

bool CheckComplexPattern(SDNode *Root, SDValue N,
      unsigned PatternNo, SmallVectorImpl<SDValue> &Result) {
  switch (PatternNo) {
  default: assert(0 && "Invalid pattern # in table?");
  case 0:
    Result.resize(Result.size()+2);
    return SelectAddrIdxOnly(Root, N, Result[Result.size()-2], Result[Result.size()-1]);
  case 1:
    Result.resize(Result.size()+2);
    return SelectAddrImm(Root, N, Result[Result.size()-2], Result[Result.size()-1]);
  case 2:
    Result.resize(Result.size()+2);
    return SelectAddrIdx(Root, N, Result[Result.size()-2], Result[Result.size()-1]);
  case 3:
    Result.resize(Result.size()+2);
    return SelectAddrImmShift(Root, N, Result[Result.size()-2], Result[Result.size()-1]);
  case 4:
    Result.resize(Result.size()+1);
    return SelectAddrImmOffs(Root, N, Result[Result.size()-1]);
  }
}

SDValue RunSDNodeXForm(SDValue V, unsigned XFormNo) {
  switch (XFormNo) {
  default: assert(0 && "Invalid xform # in table?");
  case 0: {  
    ConstantSDNode *N = cast<ConstantSDNode>(V.getNode());

  // Transformation function: shift the immediate value down into the low bits.
  return getI32Imm((unsigned)N->getZExtValue() >> 16);

  }
  case 1: {  
    ConstantSDNode *N = cast<ConstantSDNode>(V.getNode());

  // Transformation function: get the low 16 bits.
  return getI32Imm((unsigned short)N->getZExtValue());

  }
  case 2: {  
    ConstantSDNode *N = cast<ConstantSDNode>(V.getNode());

  // Transformation function: shift the immediate value down into the low bits.
  signed int Val = N->getZExtValue();
  return getI32Imm((Val - (signed short)Val) >> 16);

  }
  case 3: {  
    ConstantSDNode *N = cast<ConstantSDNode>(V.getNode());

  // Transformation function: get the start bit of a mask
  unsigned mb = 0, me;
  (void)isRunOfOnes((unsigned)N->getZExtValue(), mb, me);
  return getI32Imm(mb);

  }
  case 4: {  
    ConstantSDNode *N = cast<ConstantSDNode>(V.getNode());

  // Transformation function: get the end bit of a mask
  unsigned mb, me = 0;
  (void)isRunOfOnes((unsigned)N->getZExtValue(), mb, me);
  return getI32Imm(me);

  }
  case 5: {  
    SDNode *N = V.getNode();

  return getI32Imm(PPC::getVSPLTImmediate(N, 1));

  }
  case 6: {  
    SDNode *N = V.getNode();

  return getI32Imm(PPC::getVSPLTImmediate(N, 2));

  }
  case 7: {  
    SDNode *N = V.getNode();

  return getI32Imm(PPC::getVSPLTImmediate(N, 4));

  }
  case 8: {  
    SDNode *N = V.getNode();

  return getI32Imm(PPC::isVSLDOIShuffleMask(N, true));

  }
  case 9: {  
    SDNode *N = V.getNode();

  return getI32Imm(PPC::isVSLDOIShuffleMask(N, false));

  }
  case 10: {  
    ConstantSDNode *N = cast<ConstantSDNode>(V.getNode());

  // Transformation function: 31 - imm
  return getI32Imm(31 - N->getZExtValue());

  }
  case 11: {  
    ConstantSDNode *N = cast<ConstantSDNode>(V.getNode());

  // Transformation function: 63 - imm
  return getI32Imm(63 - N->getZExtValue());

  }
  case 12: {  
    ConstantSDNode *N = cast<ConstantSDNode>(V.getNode());

  // Transformation function: 32 - imm
  return N->getZExtValue() ? getI32Imm(32 - N->getZExtValue()) : getI32Imm(0);

  }
  case 13: {  
    ConstantSDNode *N = cast<ConstantSDNode>(V.getNode());

  // Transformation function: 64 - imm
  return N->getZExtValue() ? getI32Imm(64 - N->getZExtValue()) : getI32Imm(0);

  }
  case 14: {  
    SDNode *N = V.getNode();

  return PPC::get_VSPLTI_elt(N, 1, *CurDAG);

  }
  case 15: {  
    SDNode *N = V.getNode();

  return PPC::get_VSPLTI_elt(N, 2, *CurDAG);

  }
  case 16: {  
    SDNode *N = V.getNode();

  return PPC::get_VSPLTI_elt(N, 4, *CurDAG);

  }
  }
}

