import Qt 4.7

/* DOCME
*/
FocusScope {
    property QLauncherApplication application

    signal cancelled

    /* FIXME: a bug somewhere in Qt makes it using childrenRect.width not work:
              it is correctly updated when title.width grows bigger but not when
              it grows smaller.
    */
    width: background.width + 4
    height: childrenRect.height + 4

    Rectangle {
        id: background

        anchors.top: parent.top
        anchors.left: parent.left
        height: icon.height + 4
        width: icon.anchors.leftMargin + icon.width + labels.anchors.leftMargin + ( ( title.paintedWidth > loading.paintedWidth) ? title.paintedWidth : loading.paintedWidth ) + 19
        color: "black"
        opacity: 0.3
        radius: 5
    } 

    Image {
        id: icon

        anchors.left: parent.left
        anchors.leftMargin: 11
        anchors.verticalCenter: background.verticalCenter
        source: application ? "image://icons/"+application.icon_name : source
        width: 64
        height: 64
        sourceSize.width: width
        sourceSize.height: height
    }

    Item {
        id: labels

        anchors.left: icon.right
        anchors.leftMargin: 20
        anchors.verticalCenter: icon.verticalCenter
        width: childrenRect.width
        height: childrenRect.height

        TextCustom {
            id: title

            text: application ? application.name : text
            width: paintedWidth
            height: paintedHeight
        }

        TextCustom {
            id: loading
            text: qsTr("Loading...")
            font.pointSize: 10

            anchors.top: title.bottom
            width: paintedWidth
            height: paintedHeight
        }
    }

    AnimatedImage {
        id: loading_animation

        anchors.top: icon.bottom
        anchors.topMargin: 15
        anchors.horizontalCenter: parent.horizontalCenter
        source: "artwork/bar.gif"
        height: sourceSize.height
        width: sourceSize.width
        playing: application ? true : false
    }

    ButtonText {        
        text: qsTr("Home")
        anchors.top: labels.bottom
        anchors.topMargin: 40
        anchors.horizontalCenter: parent.horizontalCenter

        focus: true

        icon: "artwork/back.png"

        onClicked: {
            application.close()
            cancelled()
        }
    }
}
