import Qt 4.7
import gconf 1.0

/* Grid view displaying applications surrounded by a frame that clips it.

   Clicking on an application launches it.

   The 'model' property holds the list of applications that ought to be a list
   of paths to .desktop files.
   The 'delegate' property holds the delegate for the grid view.
*/
FocusScope {
    property alias model: grid.model
    property alias count: grid.count
    property alias delegate: grid.delegate
    property QLauncherApplication launching_application


    QTimer {
        id: timeout

        /* Hide loading page after a specified time. */
        onTimeout: launching_application = null
    }

    GConfItem {
        id: gconf_loading_page_timeout

        key: "/apps/hedley_launcher/loading_page_timeout"
    }

    GConfItem {
        id: gconf_loading_page_visible
        key: "/apps/hedley_launcher/loading_page_visible"
        value: {if(launching_application) return true; else return false}

        onValueChanged: {
            if(value)
                /* First parameter is the time before timeout in milliseconds.
                   Second parameter is whether or not the timeout should be
                   fired only once. */
                timeout.start(gconf_loading_page_timeout.value, true)
            else
                launching_application = null
        }
    }

    ApplicationLaunchFeedback {
        anchors.centerIn: parent
        application: launching_application ? launching_application : null
        opacity: gconf_loading_page_visible.value ? 1 : 0

        onCancelled: launching_application = null

        Behavior on opacity {NumberAnimation {duration: 200; easing.type: Easing.InOutQuad}}

        focus: gconf_loading_page_visible.value
    }

    CenteredGridView {
        id: grid

        min_horizontal_spacing: 20
        min_vertical_spacing: 15
        delegate_width: 176
        delegate_height: 172

        anchors.rightMargin: 40
        anchors.leftMargin: 40
        anchors.bottomMargin: 8
        anchors.topMargin: 8
        anchors.fill: parent

        flow: GridView.LeftToRight
        highlightRangeMode: GridView.StrictlyEnforceRange
        highlightFollowsCurrentItem: true
        preferredHighlightBegin: 35
        preferredHighlightEnd: 35
        currentIndex: 0

        clip: true
        focus: !gconf_loading_page_visible.value
        opacity: gconf_loading_page_visible.value ? 0 : 1
        Behavior on opacity {NumberAnimation {duration: 200; easing.type: Easing.InOutQuad}}

        /* FIXME: Workaround nasty consequence of QFileSystemModelQML's hack
                  where it is reset upon rowsInserted, rowsRemoved, rowsMoved
                  and the focus is lost.
        */
        property bool activeFocusBeforeReset

        Connections {
            target: model

            onModelAboutToBeReset: {
                grid.activeFocusBeforeReset = grid.activeFocus
            }
            onModelReset: {
                if(grid.activeFocusBeforeReset)
                    grid.forceActiveFocus()
            }
        }
    }
}
