import Qt 4.7

/* Item displaying an application.

   It contains:
    - a generic bordered background image
    - an icon representing the application
    - a text describing the application

   When an application is launched, the border changes appearance.
   It supports mouse hover by changing the appearance of the background image.

   The 'icon' property holds the source of the image to load as an icon.
   The 'label' property holds the text to display.
   The 'running' property is a boolean indicating whether or not the
   application is launched.
   The 'with_border' property is a boolean indicating whether or not the border
   should be visible when the mouse is not hovering the item.

   The 'clicked' signal is emitted upon clicking on the item.
*/
Item {
    property alias icon: icon.source
    property alias label: label.text
    property bool running: false
    property bool with_border: true


    signal clicked

    MouseArea {
        id: mouse

        /* FIXME: workaround double click bug
                  http://bugreports.qt.nokia.com/browse/QTBUG-12250 */
        property bool double_clicked: false

        hoverEnabled: true
        anchors.fill: parent
        onClicked: {
            if(double_clicked)
                double_clicked = false
            else
                parent.clicked()
        }
        onDoubleClicked: {
            double_clicked = true
        }
    }

    Keys.onPressed: {
        if (event.key == Qt.Key_Return || event.key == Qt.Key_Enter) {
            clicked()
            event.accepted = true;
        }
    }

    BorderImage {
        id: background

        opacity: mouse.containsMouse ? 1.0 : with_border ? 0.7 : 0.0
        border.bottom: 3
        border.top: 3
        border.right: 3
        border.left: 3
        anchors.right: parent.right
        anchors.left: parent.left
        anchors.top: parent.top
        height: parent.height*0.7
        source: "artwork/applications_item_border.png"
        smooth: false
        horizontalTileMode: BorderImage.Repeat
        verticalTileMode: BorderImage.Repeat

        Behavior on opacity {NumberAnimation {duration: 100}}
    }

    BorderImage {
        id: border_launched

        opacity: running ? 1.0 : 0.0
        border.bottom: 4
        border.top: 4
        border.right: 4
        border.left: 4
        anchors.fill: background
        source: "artwork/applications_item_launched_border.png"
        smooth: false
        horizontalTileMode: BorderImage.Repeat
        verticalTileMode: BorderImage.Repeat

        Behavior on opacity {NumberAnimation {duration: 200; easing.type: Easing.InOutQuad}}
    }

    Image {
        id: icon

        width: 64
        height: 64
        anchors.horizontalCenter: background.horizontalCenter
        anchors.verticalCenter: background.verticalCenter
        fillMode: Image.PreserveAspectFit
        sourceSize.width: width
        sourceSize.height: height

        asynchronous: true
        opacity: status == Image.Ready ? 1 : 0
        Behavior on opacity {NumberAnimation {duration: 200; easing.type: Easing.InOutQuad}}
    }

    TextCustom {
        id: label

        z: 1
        font.pointSize: 10
        wrapMode: Text.WordWrap
        horizontalAlignment: Text.AlignHCenter
        anchors.top: background.bottom
        anchors.topMargin: 7
        anchors.rightMargin: 4
        anchors.leftMargin: 4
        anchors.right: parent.right
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        font.underline: parent.activeFocus
    }

    Rectangle {
        id: label_background

        z: 0
        anchors.top: background.bottom
        anchors.topMargin: 5
        color: "black"
        opacity: 0.3
        radius: 5
        height: label.paintedHeight + 4
        width: border_launched.width
    }

}
