import Qt 4.7

/* Button item showing an icon and a text.

   It has exactly the size of the icon and text it displays.
   It supports mouse hover.

   The 'icon' property holds the path to the image to be displayed.
   The 'text' property holds the string to be displayed.
   The 'clicked' signal is emitted when the item is clicked.
*/
FocusScope {
    property alias text: label.text
    property alias icon: image.source
    property int target_padding: 10

    signal clicked

    width: layout.width + target_padding + 11
    height: layout.height + target_padding

    MouseArea {
        id: mouse

        /* FIXME: workaround double click bug
                  http://bugreports.qt.nokia.com/browse/QTBUG-12250 */
        property bool double_clicked: false

        hoverEnabled: true
        anchors.fill: parent
        onClicked: {
            if(double_clicked)
                double_clicked = false
            else
                parent.clicked()
        }
        onDoubleClicked: {
            double_clicked = true
        }
        onEntered: parent.state = "hovered"
        onExited: parent.state = "default"
    }

    Rectangle {
        id: layout_background

        z: 0
        anchors.top: parent.top
        color: "black"
        opacity: 0.3
        radius: 5
        height: parent.height
        width: parent.width
    }

    Row {
        id: layout

        spacing: 7
        anchors.centerIn: parent

        focus: true

        Image {
            id: image

            z: 1
            smooth: false
            width: sourceSize.width
            height: sourceSize.height

        } 

        TextCustom {
            id: label

            z: 1
            color: "#ffffff"
            anchors.top: image.top
            anchors.bottom: image.bottom
            verticalAlignment: Text.AlignVCenter
            font.underline: parent.activeFocus
        }

        Keys.onPressed: {
            if (event.key == Qt.Key_Return || event.key == Qt.Key_Enter) {
                parent.clicked()
                event.accepted = true;
            }
        }
    }

    states: [
        State {
            name: "hovered"
            PropertyChanges {
                   target: label
                   color: "#999999"
            }

        }
    ]
}
