#include "launcherapplication.h"
#include "iconimageprovider.h"
#include "liblauncherplugin.h"
#include "xfce4_panel_window_property.h"
#include <launcher/launcher.h>
#include <QtDeclarative/qdeclarative.h>
#include <QDeclarativeEngine>

void LibLauncherPlugin::registerTypes(const char *uri)
{
    /* Force the creation of a LauncherSession object so that it starts
       listening to window events from wnck and appropriately updates
       LauncherApplication objects upon launch of applications. */
    LauncherSession *launcher_session;
    launcher_session = launcher_session_get_default();

    qmlRegisterType<QLauncherApplication>(uri, 0, 1, "QLauncherApplication");
    qmlRegisterType<Xfce4PanelWindowProperty>(uri, 0, 1, "Xfce4PanelWindowProperty");
}

void LibLauncherPlugin::initializeEngine(QDeclarativeEngine *engine, const char *uri)
{
    engine->addImageProvider(QString("icons"), new IconImageProvider);
}


Q_EXPORT_PLUGIN2(liblauncherplugin, LibLauncherPlugin);
