#include <QDir>
#include <QDomDocument>

#include "xfce4_panel_window_property.h"

#define XFCE4_PANEL_DEFAULT_CONFIGURATION_FILE QString("/etc/xdg/xdg-xfce/xfce4/panel/panels.xml")
#define XFCE4_PANEL_CONFIGURATION_DIRECTORY QDir::homePath()+QString("/.config/xfce4/panel/")
#define XFCE4_PANEL_CONFIGURATION_FILE XFCE4_PANEL_CONFIGURATION_DIRECTORY+QString("panels.xml")

Xfce4PanelWindowProperty::Xfce4PanelWindowProperty(QObject *parent) :
    QObject(parent), size(-1), position(-1)
{
  this->loadPanelConfiguration();
  QObject::connect(&fileWatcher, SIGNAL(fileChanged(const QString &)),
                   this, SLOT(loadPanelConfiguration()) );
}

void Xfce4PanelWindowProperty::setSize(int size)
{
  if (this->size != size)
  {
    this->size = size;
    emit sizeChanged(this->size);
  }
}

int Xfce4PanelWindowProperty::getSize() const
{
  return this->size;
}

void Xfce4PanelWindowProperty::setPosition(int position)
{
  if (this->position != position)
  {
    this->position = position;
    emit positionChanged(this->position);
  }
}

int Xfce4PanelWindowProperty::getPosition() const
{
  return this->position;
}

void Xfce4PanelWindowProperty::loadPanelConfiguration()
{
  QFile configFile(XFCE4_PANEL_CONFIGURATION_FILE);

  /* If the panel has never been launched before its user configuration file
     does not exist yet. Create it. */
  if(!configFile.exists())
  {
      QDir().mkpath(XFCE4_PANEL_CONFIGURATION_DIRECTORY);
      QFile::copy(XFCE4_PANEL_DEFAULT_CONFIGURATION_FILE, XFCE4_PANEL_CONFIGURATION_FILE);
  }

  QDomDocument doc;
  doc.setContent(&configFile);

  QDomNodeList properties = doc.elementsByTagName("property");
  QDomElement property_element;
  QString name;
  QString value;

  for (unsigned int i=0; i<properties.length(); i++)
  {
    property_element = properties.item(i).toElement();
    name = property_element.attribute("name");
    value = property_element.attribute("value");

    if (name == "size")
      setSize(value.toInt());
    else if (name =="screen-position")
      setPosition(value.toInt());
  }

  /* FileSystemWatcher stops monitoring files once they have been renamed or
     removed from disk, and directories once they have been removed from disk. */
  this->fileWatcher.removePath(XFCE4_PANEL_CONFIGURATION_FILE);
  this->fileWatcher.addPath(XFCE4_PANEL_CONFIGURATION_FILE);
}
