/* mhs: A GObject wrapper for the Mozilla Mhs API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MHS_PREFS_H__
#define __MHS_PREFS_H__

#include <glib-object.h>
#include <nsIPrefService.h>
#include <nsIPrefBranch2.h>

G_BEGIN_DECLS

#define MHS_TYPE_PREFS                                             \
  (mhs_prefs_get_type())
#define MHS_PREFS(obj)                                             \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                 \
                               MHS_TYPE_PREFS,                     \
                               MhsPrefs))
#define MHS_PREFS_CLASS(klass)                                     \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                                  \
                            MHS_TYPE_PREFS,                        \
                            MhsPrefsClass))
#define MHS_IS_PREFS(obj)                                          \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                 \
                               MHS_TYPE_PREFS))
#define MHS_IS_PREFS_CLASS(klass)                                  \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                                  \
                            MHS_TYPE_PREFS))
#define MHS_PREFS_GET_CLASS(obj)                                   \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                                  \
                              MHS_TYPE_PREFS,                      \
                              MhsPrefsClass))

typedef struct _MhsPrefs         MhsPrefs;
typedef struct _MhsPrefsClass    MhsPrefsClass;
typedef struct _MhsPrefsPrivate  MhsPrefsPrivate;

struct _MhsPrefsClass
{
  GObjectClass parent_class;

  void (* read)           (MhsPrefs *prefs);
  void (* reset)          (MhsPrefs *prefs);
  void (* app_defaults)   (MhsPrefs *prefs);
  void (* branch_changed) (MhsPrefs    *prefs,
                           gint         id,
                           const gchar *domain);
};

struct _MhsPrefs
{
  GObject parent;

  MhsPrefsPrivate *priv;
};

GType mhs_prefs_get_type (void) G_GNUC_CONST;

MhsPrefs *mhs_prefs_new (void);

nsIPrefService *mhs_prefs_get_service     (MhsPrefs *prefs);

G_END_DECLS

#endif /* __MHS_PREFS_H__ */
