/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef ABOUTDIALOG_H
#define ABOUTDIALOG_H

//(*Headers(AboutDialog)
#include <wx/stattext.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

#if defined (__UNIX__)
#include <string>
using namespace std;
#endif

#if defined(__WXMSW__)
#include "wxCustomStatic.h"
#endif

class AboutDialog: public wxDialog
{
	public:

		AboutDialog(wxWindow* parent, wxWindowID id=wxID_ANY, const wxPoint& pos=wxDefaultPosition,
                    const wxSize& size=wxDefaultSize);
		virtual ~AboutDialog();

		//Declarations(AboutDialog)
		wxStaticText* m_strModuleName;
		wxStaticText* m_strVersion;
		wxStaticText* m_strCopyright;
		wxStaticText* m_strAllRight;
		wxStaticBitmap* m_BackGroundImage;
		wxButton* m_BtnOK;

	protected:
		//(*Identifiers(AboutDialog)
		static const long ID_STATICTEXTMODULENAME;
		static const long ID_STATICTEXTVERSION;
		static const long ID_STATICTEXTCOPYRIGHT;
		static const long ID_STATICTEXTALLRIGHT;
		static const long ID_BUTTON_OK;
		static const long ID_BACKGROUND_IMAGE;

	private:
		void OnButton_OKClick(wxCommandEvent& event); //Close About Dialog
		void OnClose(wxCloseEvent& event);
#if defined (__UNIX__)
		int GetLocaleFileName(int langCode, wxString& fileName);
        wxString StringToWxString(string stringValue);
        string WxStringToString(wxString wxStringValue);
#endif

		DECLARE_EVENT_TABLE()
};

#endif
