/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/****************************************************************************
File Name:          CMPC_QCPLinuxIF.h

Description:
    This file implements to call the operation system and the Device Control
    Service interfaces.
        This QCPVolumeIF class has following functions.

         1.QCP_GetVolume         Get current volume
         2.QCP_SetVolume         Set the volume
         3.QCP_SetVolumeMute     Set the mute

         This CQCPScreenRotation class has following property:

         1.QCP_RotationDegreeToIndexCW   Get the rotation degree of left
         2.QCP_RotationDegreeToIndexCCW  Get the rotation degree of right

        This QCPLinuxIF class has following property:

         1.QCP_InitDCS                   Initialize the Device Control Service
         2.QCP_InitVolumeStatus          Get initalizal volume information
         3.QCP_InitBrightnessStatus      Get initalizal brightness information
         4.QCP_InitRotation              Launch autu rotation(Default mode)
         5.QCP_LCDBrightnessUp           Set Brightness up
         6.QCP_LCDBrightnessDown         Set Brightness down
         7.QCP_VolumeUp                  Set Volume up
         8.QCP_VolumeDown                Set Volume down
         9.QCP_VolumeMute                Set Mute mode
         10.QCP_ShowCursor               Launch the show cursor tool
         11.QCP_LaunchDisplayApp         Launch the Switch Display tool
         12.QCP_LaunchScreenCalApp       Launch the Screen calibrate
         13.QCP_ScreenRotationSwitch     Switch rotation mode
         14.QCP_SetCW                    Right direction rotation
         15.QCP_SetCCW                   Left direction rotation

Environment (opt):
    OS: Ubuntu with latest service pack
    SE: CodeBlocks
Notes (opt):
  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================

  0.1        Create                      Chen Dequan   2008-7-20

  =====================================================================

****************************************************************************/
#ifndef CMPC_QCPLINUXIF_H_INCLUDED
#define CMPC_QCPLINUXIF_H_INCLUDED

#include "CMPC_QCPBasicIF.h"
#include "CMPC_QCPTypeTransfer.h"
/***************************************************************
                    External head file
***************************************************************/
#if defined(__UNIX__)
#include <wx/string.h>
#include <wx/display.h>
#include <fcntl.h>
#include <stdlib.h>

#include <sys/ioctl.h>
#include <linux/soundcard.h>
#include <X11/Xlib.h>
#include <X11/extensions/Xrandr.h>
/***************************************************************/

/***************************************************************
                   Defining volume macro
****************************************************************/
#define VOLUME_DEVICE     "/dev/mixer"  //mixer device
#define VOLUME_MIN        0x0101
/***************************************************************/

class QCPVolumeIF
{
    public:
        QCPVolumeIF();
        virtual ~QCPVolumeIF();

        bool QCP_GetVolume(int* iCurrentLevel);
        bool QCP_SetVolume(int iVolumeLevel);
        bool QCP_SetVolumeMute(int* piVolumeCopy, bool* pbMode, int iCurrentVolLevel);
    private:
        int m_iCurrentVolume;
        int m_iLeft;  //Left track
        int m_iRight; //Right track

        int m_iMute;
};

class CQCPScreenRotation
{
    public:
        CQCPScreenRotation();
        virtual ~CQCPScreenRotation();

        bool QCP_GetRotationInfo(Rotation& rCurrentRotation);
        void QCP_Rotation(Rotation rRotation);
        void QCP_RotationDegreeToIndexCW(Rotation* iDegreeToIndex, Rotation iDegree);
        void QCP_RotationDegreeToIndexCCW(Rotation* iDegreeToIndex, Rotation iDegree);
        void QCP_Rotation180DegreeToIndex(Rotation* iDegreeToIndex, Rotation iDegree);
    private:
        int      m_iScreen;
        Display* m_pDisplay;
        Window   m_WinRoot;
        XRRScreenConfiguration* m_pConfig;
        SizeID        m_iSizeID;
        XRRScreenSize m_ScreenSize;
};

class QCPInterface: public QCPBasicIF
{
    public:
        QCPInterface();
        virtual ~QCPInterface();

        bool QCP_InitDCS();
        bool QCP_InitBrightnessStatus(int *piBrightLevel);
        bool QCP_LCDBrightnessUp(int iBrightLevel, int *piBrightLevel);
        bool QCP_LCDBrightnessDown(int iBrightLevel, int *piBrightLevel);
        bool QCP_SetLCDBrightnessLevel(int iBrightLevel);
        bool QCP_InitVolumeStatus(int* piVolLevel, bool* pbMuteState);
        bool QCP_VolumeUp(int *piVolLevel);
        bool QCP_VolumeDown(int *piVolLevel);
        bool QCP_SetVolumeLevel(int iVolLevel);
        bool QCP_VolumeMute(int *piVolLevel, bool* pbStatus);
        bool QCP_GetCursorStatus();
        void QCP_ShowCursor(wxString AppShowCursor);
        void QCP_LaunchDisplayApp(wxString AppDisplay);
        bool QCP_LaunchScreenCalApp(wxString AppPath);
        bool QCP_InitRotation(BOOL* pbStatus);
        bool QCP_ScreenRotationSwitch(BOOL* pbStatus);
        void QCP_SetCW(CMPC_QCPDialog* pDlg);
        void QCP_SetCCW(CMPC_QCPDialog* pDlg);
        void QCP_Rotation180Degree(CMPC_QCPDialog* pDlg);

    private:
        QCPVolumeIF* m_pVolumeIF;
        CQCPScreenRotation* m_pScreenRotation;
        CDCSBrightRotation* m_pDCS;
        CTypeTransfer m_TypeTransfer;

        /*********************************************************
                Defining volume variable
        *********************************************************/
        bool m_bMuteState;       //Mute:true  Un-mute:false
        int m_iRight;
        int m_iLeft;
        int m_iCurrentValueOfVolume;  //Current value of volume
        int m_iVolumeCopy;       //Backup current value of volume
        int m_iVolumeMaxValue;   //Max value of volume
        int m_iCurrentLevel;      //Current level of volume

        int m_iVolumeLevelONOF;
        int m_iVolChangeLev;
        unsigned int m_iVolLevel; //Volume level
        /*********************************************************
                Defining brightness variable
        *********************************************************/
        int m_iCurrentBright;
        /*********************************************************
                Defining screen rotation variable
        *********************************************************/
        BOOL m_bStatus;     //Auto Rotation status, Enable(1), Disable(0)
        Rotation m_CurrentRotation; //Current screen rotation position
        Rotation m_Rotation;        //Setting rotation
};

#endif //__UNIX__
#endif // CMPC_QCPLINUXIF_H_INCLUDED

