/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/****************************************************************************
File Name:          CMPC_QCPSearchFilePath.cpp
Description:
    This file implements to get the file path of application
        This CSearchFilePath class has following functions.

         1.WindowsGetFilePath     Get the directory of executable file on widows
         2.LinuxGetFilePath       Get the directory of executable file on Linux

Environment (opt):
    OS: Windows XP table and Ubuntu
    SE: CodeBlocks
Notes (opt):
  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================

  0.1        Create                       Chen Dequan   2008-8-10

  =====================================================================

****************************************************************************/
#ifndef CMPC_QCPSEARCHFILEPATH_H_INCLUDED
#define CMPC_QCPSEARCHFILEPATH_H_INCLUDED

#include <wx/stdpaths.h>
#include "wx/string.h"

class CSearchFilePath
{
    public:
        CSearchFilePath();
        virtual ~CSearchFilePath();

        #if defined(__WXMSW__)
        wxString WindowsGetFilePath();
        #elif defined(__UNIX__)
        wxString LinuxGetFilePath();
        #endif
};

#endif // CMPC_QCPSEARCHFILEPATH_H_INCLUDED
