/* udisks-automounter.c generated by valac 0.10.0, the Vala compiler
 * generated from udisks-automounter.vala, do not modify */

/* Simple udisks based automounter
 *
 * (C) 2010 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <stdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))

#define UDISKS_TYPE_DEVICE (udisks_device_get_type ())
#define UDISKS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UDISKS_TYPE_DEVICE, UDisksDevice))
#define UDISKS_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UDISKS_TYPE_DEVICE))
#define UDISKS_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UDISKS_TYPE_DEVICE, UDisksDeviceIface))

typedef struct _UDisksDevice UDisksDevice;
typedef struct _UDisksDeviceIface UDisksDeviceIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _OnDeviceAddedAsyncData OnDeviceAddedAsyncData;

#define UDISKS_TYPE_DAEMON (udisks_daemon_get_type ())
#define UDISKS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UDISKS_TYPE_DAEMON, UDisksDaemon))
#define UDISKS_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UDISKS_TYPE_DAEMON))
#define UDISKS_DAEMON_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UDISKS_TYPE_DAEMON, UDisksDaemonIface))

typedef struct _UDisksDaemon UDisksDaemon;
typedef struct _UDisksDaemonIface UDisksDaemonIface;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _UDisksDeviceIface {
	GTypeInterface parent_iface;
	void (*filesystem_mount) (UDisksDevice* self, const char* filesystem_type, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char* (*filesystem_mount_finish) (UDisksDevice* self, GAsyncResult* _res_, GError** error);
	void (*filesystem_unmount) (UDisksDevice* self, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*filesystem_unmount_finish) (UDisksDevice* self, GAsyncResult* _res_, GError** error);
	char* (*get_device_file) (UDisksDevice* self);
	char* (*get_id_usage) (UDisksDevice* self);
	gboolean (*get_device_is_mounted) (UDisksDevice* self);
	gboolean (*get_device_is_partition) (UDisksDevice* self);
	gboolean (*get_device_is_removable) (UDisksDevice* self);
	gboolean (*get_device_is_system_internal) (UDisksDevice* self);
	gboolean (*get_device_presentation_hide) (UDisksDevice* self);
	gboolean (*get_device_presentation_nopolicy) (UDisksDevice* self);
};

struct _OnDeviceAddedAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	char* device;
	gboolean open_client;
	UDisksDevice* dev;
	char* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	char* _tmp5_;
	gboolean _tmp6_;
	char* path;
	char** _tmp7_;
	char** _tmp8_;
	gint _tmp8__length1;
	char* _tmp9_;
	gint pid;
	gboolean _tmp13_;
	char** _tmp10_;
	char** _tmp11_;
	gint _tmp11__length1;
	gboolean _tmp12_;
	GError * __err;
	const char** client_collection;
	int client_collection_length1;
	int client_it;
	char* client;
	GError * _inner_error_;
};

struct _UDisksDaemonIface {
	GTypeInterface parent_iface;
	char** (*enumerate_devices) (UDisksDaemon* self, int* result_length1, GError** error);
	char** (*enumerate_device_files) (UDisksDaemon* self, int* result_length1, GError** error);
	char* (*get_daemon_version) (UDisksDaemon* self);
};


extern DBusGConnection* dbus;
DBusGConnection* dbus = NULL;
extern gboolean coldplug;
gboolean coldplug = TRUE;

static void on_device_added_async_data_free (gpointer _data);
static void on_device_added_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void on_device_added_async (const char* device, GAsyncReadyCallback _callback_, gpointer _user_data_);
void on_device_added_finish (GAsyncResult* _res_);
static gboolean on_device_added_async_co (OnDeviceAddedAsyncData* data);
UDisksDevice* udisks_device_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType udisks_device_get_type (void) G_GNUC_CONST;
char* udisks_device_get_device_file (UDisksDevice* self);
char* udisks_device_get_id_usage (UDisksDevice* self);
gboolean udisks_device_get_device_is_mounted (UDisksDevice* self);
gboolean udisks_device_get_device_is_system_internal (UDisksDevice* self);
gboolean udisks_device_get_device_presentation_hide (UDisksDevice* self);
gboolean udisks_device_get_device_presentation_nopolicy (UDisksDevice* self);
void udisks_device_filesystem_mount (UDisksDevice* self, const char* filesystem_type, char** options, int options_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
char* udisks_device_filesystem_mount_finish (UDisksDevice* self, GAsyncResult* _res_, GError** error);
void on_device_added (const char* device);
void on_device_removed (const char* device);
gint _vala_main (char** args, int args_length1);
UDisksDaemon* udisks_daemon_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType udisks_daemon_get_type (void) G_GNUC_CONST;
char* udisks_daemon_get_daemon_version (UDisksDaemon* self);
char** udisks_daemon_enumerate_devices (UDisksDaemon* self, int* result_length1, GError** error);
static void _on_device_added_udisks_daemon_device_added (UDisksDaemon* _sender, const char* device, gpointer self);
static void _on_device_removed_udisks_daemon_device_removed (UDisksDaemon* _sender, const char* device, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

const char* gui_clients[4] = {"Thunar", "nautilus", "pcmanfm", "emelfm2"};


static void on_device_added_async_data_free (gpointer _data) {
	OnDeviceAddedAsyncData* data;
	data = _data;
	_g_free0 (data->device);
	g_slice_free (OnDeviceAddedAsyncData, data);
}


void on_device_added_async (const char* device, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	OnDeviceAddedAsyncData* _data_;
	_data_ = g_slice_new0 (OnDeviceAddedAsyncData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, on_device_added_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, on_device_added_async_data_free);
	_data_->device = g_strdup (device);
	on_device_added_async_co (_data_);
}


void on_device_added_finish (GAsyncResult* _res_) {
	OnDeviceAddedAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void on_device_added_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	OnDeviceAddedAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	on_device_added_async_co (data);
}


static gboolean on_device_added_async_co (OnDeviceAddedAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 1:
		goto _state_1;
	}
	_state_0:
	data->open_client = !coldplug;
	data->dev = udisks_device_dbus_proxy_new (dbus, "org.freedesktop.UDisks", data->device);
	fprintf (stdout, "Device added: %s (%s)\n", data->device, data->_tmp0_ = udisks_device_get_device_file (data->dev));
	_g_free0 (data->_tmp0_);
	if ((data->_tmp6_ = _vala_strcmp0 (data->_tmp5_ = udisks_device_get_id_usage (data->dev), "filesystem") == 0, _g_free0 (data->_tmp5_), data->_tmp6_)) {
		data->_tmp4_ = !udisks_device_get_device_is_mounted (data->dev);
	} else {
		data->_tmp4_ = FALSE;
	}
	if (data->_tmp4_) {
		data->_tmp3_ = !udisks_device_get_device_is_system_internal (data->dev);
	} else {
		data->_tmp3_ = FALSE;
	}
	if (data->_tmp3_) {
		data->_tmp2_ = !udisks_device_get_device_presentation_hide (data->dev);
	} else {
		data->_tmp2_ = FALSE;
	}
	if (data->_tmp2_) {
		data->_tmp1_ = !udisks_device_get_device_presentation_nopolicy (data->dev);
	} else {
		data->_tmp1_ = FALSE;
	}
	if (data->_tmp1_) {
		fprintf (stdout, "  appropriate for auto-mounting\n");
		data->_tmp7_ = NULL;
		data->_state_ = 1;
		udisks_device_filesystem_mount (data->dev, "", (data->_tmp8_ = (data->_tmp7_ = g_new0 (char*, 1 + 1), data->_tmp7_[0] = g_strdup ("auth_no_user_interaction"), data->_tmp7_), data->_tmp8__length1 = 1, data->_tmp8_), 1, on_device_added_async_ready, data);
		return FALSE;
		_state_1:
		data->path = (data->_tmp9_ = udisks_device_filesystem_mount_finish (data->dev, data->_res_, &data->_inner_error_), data->_tmp8_ = (_vala_array_free (data->_tmp8_, data->_tmp8__length1, (GDestroyNotify) g_free), NULL), data->_tmp9_);
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->dev);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		fprintf (stdout, "  mounted to: %s\n", data->path);
		if (data->open_client) {
			{
				data->client_collection = gui_clients;
				data->client_collection_length1 = G_N_ELEMENTS (gui_clients);
				for (data->client_it = 0; data->client_it < G_N_ELEMENTS (gui_clients); data->client_it = data->client_it + 1) {
					data->client = g_strdup (data->client_collection[data->client_it]);
					{
						fprintf (stdout, "  trying to launch %s\n", data->client);
						{
							data->_tmp10_ = NULL;
							data->_tmp13_ = (data->_tmp12_ = g_spawn_async (NULL, (data->_tmp11_ = (data->_tmp10_ = g_new0 (char*, 2 + 1), data->_tmp10_[0] = g_strdup (data->client), data->_tmp10_[1] = g_strdup (data->path), data->_tmp10_), data->_tmp11__length1 = 2, data->_tmp11_), NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &data->pid, &data->_inner_error_), data->_tmp11_ = (_vala_array_free (data->_tmp11_, data->_tmp11__length1, (GDestroyNotify) g_free), NULL), data->_tmp12_);
							if (data->_inner_error_ != NULL) {
								goto __catch0_g_error;
							}
							if (data->_tmp13_) {
								fprintf (stdout, "  success!\n");
							}
							_g_free0 (data->client);
							break;
						}
						goto __finally0;
						__catch0_g_error:
						{
							data->__err = data->_inner_error_;
							data->_inner_error_ = NULL;
							{
							}
						}
						__finally0:
						if (data->_inner_error_ != NULL) {
							_g_free0 (data->client);
							_g_free0 (data->path);
							_g_object_unref0 (data->dev);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
							g_clear_error (&data->_inner_error_);
							return FALSE;
						}
						_g_free0 (data->client);
					}
				}
			}
		}
		_g_free0 (data->path);
	}
	_g_object_unref0 (data->dev);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


void on_device_added (const char* device) {
	g_return_if_fail (device != NULL);
	on_device_added_async (device, NULL, NULL);
}


void on_device_removed (const char* device) {
	g_return_if_fail (device != NULL);
	fprintf (stdout, "Device removed: %s\n", device);
}


static void _on_device_added_udisks_daemon_device_added (UDisksDaemon* _sender, const char* device, gpointer self) {
	on_device_added (device);
}


static void _on_device_removed_udisks_daemon_device_removed (UDisksDaemon* _sender, const char* device, gpointer self) {
	on_device_removed (device);
}


gint _vala_main (char** args, int args_length1) {
	gint result = 0;
	UDisksDaemon* udisks;
	char* _tmp3_;
	gint _tmp5__length1;
	gint __tmp5__size_;
	char** _tmp6_;
	gint _tmp4_;
	char** _tmp5_;
	GMainLoop* _tmp7_;
	GError * _inner_error_ = NULL;
	udisks = NULL;
	{
		DBusGConnection* _tmp0_;
		DBusGConnection* _tmp1_;
		UDisksDaemon* _tmp2_;
		_tmp0_ = dbus_g_bus_get (DBUS_BUS_SYSTEM, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch1_dbus_gerror;
			}
			_g_object_unref0 (udisks);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		dbus = (_tmp1_ = _tmp0_, _dbus_g_connection_unref0 (dbus), _tmp1_);
		udisks = (_tmp2_ = udisks_daemon_dbus_proxy_new (dbus, "org.freedesktop.UDisks", "/org/freedesktop/UDisks"), _g_object_unref0 (udisks), _tmp2_);
	}
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Could not connect to UDisks: %s\n", e->message);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (udisks);
			return result;
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (udisks);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	fprintf (stdout, "Connected to UDisks %s\n", _tmp3_ = udisks_daemon_get_daemon_version (udisks));
	_g_free0 (_tmp3_);
	_tmp5_ = (_tmp6_ = udisks_daemon_enumerate_devices (udisks, &_tmp4_, &_inner_error_), _tmp5__length1 = _tmp4_, __tmp5__size_ = _tmp5__length1, _tmp6_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (udisks);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		char** o_collection;
		int o_collection_length1;
		int o_it;
		o_collection = _tmp5_;
		o_collection_length1 = _tmp5__length1;
		for (o_it = 0; o_it < _tmp5__length1; o_it = o_it + 1) {
			char* o;
			o = g_strdup (o_collection[o_it]);
			{
				on_device_added_async (o, NULL, NULL);
				_g_free0 (o);
			}
		}
		o_collection = (_vala_array_free (o_collection, o_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	coldplug = FALSE;
	g_signal_connect (udisks, "device-added", (GCallback) _on_device_added_udisks_daemon_device_added, NULL);
	g_signal_connect (udisks, "device-removed", (GCallback) _on_device_removed_udisks_daemon_device_removed, NULL);
	g_main_loop_run (_tmp7_ = g_main_loop_new (NULL, FALSE));
	_g_main_loop_unref0 (_tmp7_);
	result = 0;
	_g_object_unref0 (udisks);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




