#!/bin/bash
source yourpath/common_functions.sh

function check_ports {
    echo "checking ports"
    startcheck
}

function start {
    echo "starting all"
    /etc/init.d/firehol start;
    /etc/init.d/tinyproxy start;
    /etc/init.d/dansguardian start;
}

function stop {
    echo "stopping all"
    /etc/init.d/firehol stop;
    /etc/init.d/tinyproxy stop;
    /etc/init.d/dansguardian stop;
}

set_ports()
{
    echo "setting ports"
    yourpath/set_ports_nogui.sh $1 $2
}

proxyport_start_index=3128
proxyport_end_index=3129
filterport_start_index=8080
filterport_end_index=8081

for (( proxyport = $proxyport_start_index ; proxyport <= $proxyport_end_index ; proxyport++ ))
do
    for (( filterport = $filterport_start_index ; filterport <= $filterport_end_index ; filterport++ ))
    do
	echo proxyport=$proxyport filterport=$filterport
	echo "==========================================="
	set_ports $proxyport $filterport
	echo "==========================================="
	stop
	echo "==========================================="
	start
	echo "==========================================="
	if check_ports
	then
	    exit 0
	fi
	echo "==========================================="
    done;
done;
