#!/bin/bash
# set -x #for debugging
set -u

status()
{
    N=$( find /etc/rc* -name *$SERVICE | wc -l )
    if [ $N -eq 0 ]
    then
	echo "STATUS: $SERVICE is deactivated. It will not run on startup."
	return 0
    else
	echo "STATUS: $SERVICE is activated. It will run on startup."
	return 1
    fi
}

activate_service()
{
    if [ $SERVICE = 'firehol' ]; then update-rc.d firehol start 41 S . start 36 0 6 . ; fi
    if [ $SERVICE = 'tinyproxy' ]; then update-rc.d tinyproxy defaults ; fi
    if [ $SERVICE = 'dansguardian' ]; then update-rc.d dansguardian defaults 50 19 ; fi
}

deactivate_service()
{
    update-rc.d -f $SERVICE remove
}

if [ $# -ne 2 ]
then
        echo "usage : $0 <service> <on/off/status/status_for_GUI>"
        exit 0
fi

SERVICE=$1
ACTION=$2

if [ $ACTION = 'on' ]
then
    status
    activate_service
    status
    if [ $? -eq 1 ]
    then
	echo "Activation successful"
    else
	echo "Activation not successful"
    fi
fi

if [ $ACTION = 'off' ]
then
    status
    deactivate_service
    status
    if [ $? -eq 0 ]
    then
	echo "Deactivation successful"
    else
	echo "Deactivation not successful"
    fi
fi

if [ $ACTION = 'status' ]
then
    status
    exit $?
fi

if [ $ACTION = 'status_for_GUI' ]
then
    status >/dev/null
    echo $?
fi
